package xyz.zhiwei.explorer.web.support;

import java.awt.image.BufferedImage;
import java.io.IOException;

import javax.imageio.ImageIO;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;

/**
 * http响应工具
 */
public class HttpResponseUtil {

	/**
	 * 向浏览器输出图片
	 * @param response
	 * @param buffImg
	 */
	public static void sendPicToBrowser(HttpServletResponse response,BufferedImage buffImg) {
        // 禁止图像缓存。
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);
        response.setContentType("image/jpeg");
 
        // 将图像输出到Servlet输出流中。
        try {
            ServletOutputStream sos = response.getOutputStream();
			ImageIO.write(buffImg, "jpeg", sos);
	        sos.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
}
