package xyz.zhiwei.explorer.web;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.service.MorphismResponse;
import xyz.zhiwei.cognitivedesign.service.Service;
import xyz.zhiwei.explorer.api.support.Message;
import xyz.zhiwei.explorer.morphism.appearance.linkman.add.LinkmanAddAppearance;
import xyz.zhiwei.explorer.morphism.appearance.linkman.page.LinkmanExplorerFacet;
import xyz.zhiwei.explorer.morphism.appearance.linkman.page.LinkmanPageAppearance;
import xyz.zhiwei.explorer.morphism.principle.base.model.LifePrinciple;
import xyz.zhiwei.explorer.morphism.support.facet.Page;
import xyz.zhiwei.explorer.morphism.support.facet.PageCondition;
import xyz.zhiwei.explorer.web.support.RequestConstant;

@RestController
@RequestMapping({"/linkman"})
public class LinkmanController {
    @Autowired
    private Service service;

	@Autowired
	protected HttpServletRequest request;


	/**
	 * 联系人分页
	 * TODO 与原来的入参字段不同
	 * @param a
	 * @return
	 */
	@RequestMapping(value = "queryinpage.do", method = RequestMethod.POST)
	public Message<Page<LinkmanExplorerFacet>> queryPage(@RequestBody PageCondition<LifePrinciple<Long>> condition) {
		String token=request.getHeader(RequestConstant.TOKEN);
		PageCondition<Date> conditionDate=condition.change(LifePrinciple::getCreateTime);
		LinkmanPageAppearance init=new LinkmanPageAppearance(token,conditionDate);
		LinkmanPageAppearance pre=service.view(init);
		
		return Message.success(pre.getPage());
	}
	
	
	/**
	 * 新增
	 * TODO 与原来的入参字段不同
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "addforkey.do", method = RequestMethod.POST)
	public Message<Long> addforkey(@RequestBody Principle<Long> initial) {
		String token=request.getHeader(RequestConstant.TOKEN);

		LinkmanAddAppearance init=new LinkmanAddAppearance(token,initial.getId());
		MorphismResponse<LinkmanAddAppearance> resp=service.process(init);
		
		return Message.success(resp.getAdditionResponse(1));
		
	}
	
}
