package xyz.zhiwei.explorer.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import xyz.zhiwei.cognitivedesign.service.MorphismResponse;
import xyz.zhiwei.cognitivedesign.service.Service;
import xyz.zhiwei.explorer.api.support.Message;
import xyz.zhiwei.explorer.morphism.appearance.letter.add.LetterAddAppearance;
import xyz.zhiwei.explorer.morphism.appearance.letter.add.LetterAddInit;
import xyz.zhiwei.explorer.morphism.appearance.letter.pageupdate.LetterPageReadUpdateAppearance;
import xyz.zhiwei.explorer.morphism.appearance.letter.pageupdate.LetterPageReadUpdateInit;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Letter;
import xyz.zhiwei.explorer.morphism.support.facet.Page;
import xyz.zhiwei.explorer.morphism.support.facet.PageCondition;
import xyz.zhiwei.explorer.web.support.RequestConstant;

@RestController
@RequestMapping({"/letter"})
public class LetterController {
    @Autowired
    private Service service;

	@Autowired
	protected HttpServletRequest request;


	/**
	 * 私信分页
	 * 
	 * @param a
	 * @return
	 */
	@RequestMapping(value = "queryinpage.do", method = RequestMethod.POST)
	public Message<Page<Letter>> queryPage(@RequestBody PageCondition<LetterPageReadUpdateInit> initial) {
		String token=request.getHeader(RequestConstant.TOKEN);
		
		LetterPageReadUpdateAppearance init=new LetterPageReadUpdateAppearance(token,initial);
		LetterPageReadUpdateAppearance pre=service.view(init);
		return Message.success(pre.getLetterPage());
	}
	

	/**
	 * 新增
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "addforkey.do", method = RequestMethod.POST)
	public Message<Letter> addforkey(@RequestBody LetterAddInit initial) {
		String token=request.getHeader(RequestConstant.TOKEN);

		LetterAddAppearance init=new LetterAddAppearance(token,initial);
		MorphismResponse<LetterAddAppearance> resp=service.process(init);
		
		return Message.success(resp.getA().getLetter());
	}
	
}
