package xyz.zhiwei.explorer.web;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import xyz.zhiwei.cognitivedesign.dao.Dao;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.service.MorphismResponse;
import xyz.zhiwei.cognitivedesign.service.Service;
import xyz.zhiwei.explorer.api.ExplorerApi;
import xyz.zhiwei.explorer.api.support.Message;
import xyz.zhiwei.explorer.morphism.appearance.explorer.register.ExplorerRegisterAppearance;
import xyz.zhiwei.explorer.morphism.appearance.explorer.register.ExplorerRegisterInit;
import xyz.zhiwei.explorer.morphism.appearance.explorer.unique.ExplorerCheckUniqueAppearance;
import xyz.zhiwei.explorer.morphism.appearance.explorer.unique.ExplorerUniqueInit;
import xyz.zhiwei.explorer.morphism.appearance.explorer.update.ExplorerUpdateAppearance;
import xyz.zhiwei.explorer.morphism.appearance.explorer.update.ExplorerUpdateInit;
import xyz.zhiwei.explorer.morphism.appearance.session.code.SessionCodeAppearance;
import xyz.zhiwei.explorer.morphism.appearance.session.create.SessionCreateAppearance;
import xyz.zhiwei.explorer.morphism.appearance.session.delete.SessionDeleteAppearance;
import xyz.zhiwei.explorer.morphism.appearance.session.login.SessionLoginAppearance;
import xyz.zhiwei.explorer.morphism.appearance.session.login.SessionLoginInit;
import xyz.zhiwei.explorer.morphism.appearance.session.logoncode.LoginByCodeInit;
import xyz.zhiwei.explorer.morphism.appearance.session.logoncode.SessionLoginByCodeAppearance;
import xyz.zhiwei.explorer.morphism.appearance.session.view.SessionViewAppearance;
import xyz.zhiwei.explorer.morphism.appearance.shortmessage.login.ShortMessageLoginAppearance;
import xyz.zhiwei.explorer.morphism.appearance.shortmessage.register.ShortMessageRegisterAppearance;
import xyz.zhiwei.explorer.morphism.facet.shortmessage.ShortMessageCodeInit;
import xyz.zhiwei.explorer.morphism.principle.base.model.VerificationCode;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.explorer.morphism.support.exception.BusinessException;
import xyz.zhiwei.explorer.morphism.support.util.ObjectExtend;
import xyz.zhiwei.explorer.morphism.support.util.RandomCode;
import xyz.zhiwei.explorer.web.support.HttpResponseUtil;
import xyz.zhiwei.explorer.web.support.RequestConstant;

@RestController
@RequestMapping({"/explorer"})
public class ExplorerController implements ExplorerApi{
	@Autowired
	protected HttpServletRequest request;
    @Autowired 
    private  HttpServletResponse response;

    @Autowired
    private Service service;

    @Autowired
    private Dao<Explorer> explorerDaoImpl;

    
	
    /*
     *=======================================  Explorer ================================================= 
     */
	
	//=================================  查询  ================================
	/**
	 * 探索者详情
	 */
	@RequestMapping(value = "queryone.do", method = RequestMethod.POST)
	@Override
	public Message<Explorer> queryone(@RequestBody Principle<Long> condition) {

		PrincipleQualifier<Explorer> pq=ExplorerQualify.PQ.pk(condition.getId());
		List<Explorer> explorerList=explorerDaoImpl.subCollection(pq);
		
		return Message.success(explorerList.stream().findFirst().orElse(null));
	}

	
	/**
	 * 探索者列表
	 */
	@RequestMapping(value = "queryids.do", method = RequestMethod.POST)
	@Override
	public Message<List<Explorer>> queryids(@RequestBody List<Principle<Long>> condition) {

		PrincipleQualifier<Explorer> pq=ExplorerQualify.PQ.principleList(condition);
		List<Explorer> explorerList=explorerDaoImpl.subCollection(pq);
		
		return Message.success(explorerList);
	}
	

	/**
	 * 唯一性检查
	 * @param request
	 * @return
	 */
    @RequestMapping(value = {"checkUnique.do"},method = {RequestMethod.POST})
    public Message<Explorer> checkUnique(@RequestBody ExplorerUniqueInit condition) {
    	ExplorerCheckUniqueAppearance init=new ExplorerCheckUniqueAppearance(condition);
    	ExplorerCheckUniqueAppearance pre=service.view(init);
    	
    	Explorer exist=pre.getExplorerExist();
    	if("exist".equals(exist.getName())||"exist".equals(exist.getTelphone())) {
    		return Message.failure(201,"用户名或手机号已存在",exist);
    	}
		
		return Message.success(exist);
    }
    
    
	

	//=================================  更新  ================================
	

	/**
	 * 注册
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "addsign.do", method = RequestMethod.POST)
	public Message<Explorer> addsign(@RequestBody ExplorerRegisterInit initial) {
		//参数校验
		if(!ObjectExtend.hasSubstance(initial.getName())
				||!ObjectExtend.hasSubstance(initial.getPassword())
				||!ObjectExtend.hasSubstance(initial.getTelphone())){
			return Message.failure(203, "用户名,密码,手机号不能为空");
		}

		String token=request.getHeader(RequestConstant.TOKEN);
		
		try {
			ExplorerRegisterAppearance init=new ExplorerRegisterAppearance(token,initial);
			MorphismResponse<ExplorerRegisterAppearance> resp=service.process(init);
			
			Session session=resp.getA().getSessionUpdate();
			Explorer user=session.getUser();
			user.setPassword(session.getId());
			
			return Message.success("注册成功",user);
		} catch (BusinessException e) {
			return Message.failure(e.getErrorCode(),e.getMessage(),null);
		}
	}
    

	/**
	 * 更新
	 * @author zhanghaiting
	 * @parameter
	 * @return
	 */
	@RequestMapping(value = "update.do", method = RequestMethod.POST)
	public Message<Long> update(@RequestBody ExplorerUpdateInit initial) {
		String token=request.getHeader(RequestConstant.TOKEN);
		ExplorerUpdateAppearance init=new ExplorerUpdateAppearance(token,initial);
		MorphismResponse<ExplorerUpdateAppearance> resp=service.process(init);
		
		return Message.success(resp.getModificationResponse(0));
	}
	
	
	/**
	 * 更新统计数
	 * @param list
	 * @return
	 */
	@RequestMapping(value = "updateList.do", method = RequestMethod.POST)
	@Override
	public Message<Long> updateList(@RequestBody List<Explorer> list) {
		return Message.success(explorerDaoImpl.update(list));
	} 
	

	/**
	 * 更新密码
	 * @author zhanghaiting
	 * @parameter
	 * @return
	@RequestMapping(value = "updatepassword.do", method = RequestMethod.POST)
	public Message<Integer> updatePassword(@RequestBody ExplorerUpdatePasswordModel c) {
		String token=request.getHeader(TOKEN);
		ExplorerUpdatePasswordAppearance a=new ExplorerUpdatePasswordAppearance(token,c);
		try {
			ProcessResponse<ExplorerUpdatePasswordAppearance,Explorer> r=service.process(a);
			return Message.success("密码修改成功！",r.getSaveResponseList().getFirst().getModificationResponse().intValue());
		} catch (BusinessException e) {
			return Message.failure(e.getErrorCode(),e.getMessage(),null);
		}
	}
	 */
	
    /*
     *=======================================  session ================================================= 
     */

	/**
	 * 创建session
	 * @author zhanghaiting
	 *
	 * @param req
	 * @param resp token
	 * @return
	 */
	 @RequestMapping("tokenForCode.do")
	 public Message<String> tokenForCode() {
		String token=request.getHeader(RequestConstant.TOKEN);
		SessionCreateAppearance init=new SessionCreateAppearance(token);
		MorphismResponse<SessionCreateAppearance> resp=service.process(init);
		return Message.success(resp.getA().getSessionFacet().getToken());
	 }

	
	/**
	 * 登录
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "login.do", method = RequestMethod.POST)
	public Message<Explorer> login(@RequestBody SessionLoginInit initial) {
		try {
			SessionLoginAppearance init=new SessionLoginAppearance(initial);
			MorphismResponse<SessionLoginAppearance> resp=service.process(init);
			Session session=resp.getA().getSessionFacet().getNewSession();
			if(null==session) {
				return Message.failure("登录失败",null);
			}
			if(1!=resp.getAdditionResponse(0)) {
				return Message.failure("登录失败,服务器错误",null);
			}
			Explorer user=session.getUser();
			user.setPassword(session.getId());
			return Message.success("登录成功",user);
		} catch (BusinessException e) {
			return Message.failure(e.getErrorCode(),e.getMessage(),null);
		}
	}


	/**
	 * 验证码登录
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "loginByCode.do", method = RequestMethod.POST)
	public Message<Explorer> loginByCode(@RequestBody LoginByCodeInit initial) {
		String token=request.getHeader(RequestConstant.TOKEN);

		try {
			SessionLoginByCodeAppearance init=new SessionLoginByCodeAppearance(token,initial);
			MorphismResponse<SessionLoginByCodeAppearance> resp=service.process(init);
			Session session=resp.getA().getSessionFacet().getUpSession();
			if(null==session) {
				return Message.failure("登录失败",null);
			}
			Explorer user=session.getUser();
			user.setPassword(session.getId());
			return Message.success("登录成功",user);
		} catch (BusinessException e) {
			return Message.failure(e.getErrorCode(),e.getMessage(),null);
		}
		
	}
	

	/**
	 * 获取Session中的用户
	 * @parameter
	 * @return
	 */
	@RequestMapping(value = "getLoginUser.do")
	public Message<Explorer> getloginuser(){
		String token=request.getHeader(RequestConstant.TOKEN);
		SessionViewAppearance init=new SessionViewAppearance(token);
		SessionViewAppearance pre=service.view(init);
		Explorer loginUser=pre.getLoginUser();
		if(null==loginUser) {
			return Message.failure(212, "用户未登录");
		}
		return Message.success(pre.getLoginUser());
	}
	
	/**
	 * 注销
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "logout.do")
	public Message<Long> logout() {
		String token=request.getHeader(RequestConstant.TOKEN);
		SessionDeleteAppearance init=new SessionDeleteAppearance(token);
		MorphismResponse<SessionDeleteAppearance> resp=service.process(init);
		return Message.success(resp.getDeletionResponse(0));
	}
    

	
	/**
	 * 更新Session中的用户
	 * @author zhanghaiting
	 * TODO 
	 * @parameter
	 * @return
	 */
	@RequestMapping(value = "updateLoginUser.do")
	public Message<Explorer> updateLoginUser(){
//		String token=request.getHeader(TOKEN);
//		SessionUpdateFromDbAppearance a=new SessionUpdateFromDbAppearance(token);
//		SessionUpdateFromDbAppearance r=service.process(a).getA();
//		return Message.success(r.getUser()); 
		return getloginuser(); 
	}
	
	
	
	
	
	/*
	 * =======================  图片验证码  =========================
	 */
	

	
	/**
	 * 获取图片验证码
	 * @author zhanghaiting
	 * @parameter
	 * @return
	 */
	 @RequestMapping("getCode.do")
	 public void getCode(){
		String token=request.getParameter(RequestConstant.TOKEN);
		SessionCodeAppearance init=new SessionCodeAppearance(token);
		MorphismResponse<SessionCodeAppearance> resp=service.process(init);
	 	//验证码转为图片并发送给浏览器
	 	String code=resp.getA().getSessionFacet().getSession().getCode().getPicCode();
	 	BufferedImage buffImg =RandomCode.getPicForCodes(code);
	 	HttpResponseUtil.sendPicToBrowser(response, buffImg);
    }
	
	 

	/**
	 * 图片验证码预检
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "checkCode.do", method = RequestMethod.POST)
	public Message<String> checkCode(@RequestBody VerificationCode condition) {
		//参数校验
		if(!ObjectExtend.hasSubstance(condition.getPicCode())){
			return Message.failure(201, "验证码不能为空",null);
		}

		String token=request.getHeader(RequestConstant.TOKEN);
		SessionViewAppearance init=new SessionViewAppearance(token);
		SessionViewAppearance pre=service.view(init);
		Session session=pre.getSession();
		
		//校验验证码
		VerificationCode codeModelSession=session.getCode();
		if (!condition.getPicCode().equalsIgnoreCase(codeModelSession.getPicCode())){
			return Message.failure(202, "图片验证码不正确",null);
		}else{
			return Message.success("图片验证码验证通过", null);
		}
			
	}
		


	/*
	 * ======================= 手机验证码  ===========================
	 */
	

	 /**
	  * 发送注册手机验证码
	  * @param request
	  * @return
	  */
	@RequestMapping(value = "sendRegisterCodeMsg.do", method = RequestMethod.POST)
	 public Message<String> sendRegisterCodeMsg(@RequestBody ShortMessageCodeInit initial){
		//手机号
		if(!ObjectExtend.hasSubstance(initial.getPhone()) || !isMobileNO(initial.getPhone())){
			return Message.failure(204, "请检查手机号");
		}
		//参数校验
		if(!ObjectExtend.hasSubstance(initial.getPicCode())){
			return Message.failure(201, "图片验证码不能为空");
		}
		String token=request.getHeader(RequestConstant.TOKEN);
		
		try {
			ShortMessageRegisterAppearance init=new ShortMessageRegisterAppearance(token,initial);
			MorphismResponse<ShortMessageRegisterAppearance> resp=service.process(init);
			if(1L==resp.getAdditionResponse(0)) {
				return Message.success("验证码已发送，请注意查收。", null);
			}else {
				return Message.success("验证码发送失败，请稍后重试。", null);
			}
		} catch (BusinessException e) {
			return Message.failure(e.getErrorCode(),e.getMessage(),null);
		}
		
	 }
	 
	

	 /**
	  * 发送登录手机验证码
	  * @param request
	  * @return
	  */
	@RequestMapping(value = "sendLoginCodeMsg.do", method = RequestMethod.POST)
	 public Message<String> sendLoginCodeMsg(@RequestBody ShortMessageCodeInit initial){
		//手机号
		if(!ObjectExtend.hasSubstance(initial.getPhone()) || !isMobileNO(initial.getPhone())){
			return Message.failure(204, "请检查手机号");
		}
		//参数校验
		if(!ObjectExtend.hasSubstance(initial.getPicCode())){
			return Message.failure(201, "图片验证码不能为空");
		}
		
		String token=request.getHeader(RequestConstant.TOKEN);
		try {
			ShortMessageLoginAppearance init=new ShortMessageLoginAppearance(token,initial);
			MorphismResponse<ShortMessageLoginAppearance> resp=service.process(init);
			if(1L==resp.getAdditionResponse(0)) {
				return Message.success("验证码已发送，请注意查收。", null);
			}else {
				return Message.success("验证码发送失败，请稍后重试。", null);
			}
		} catch (BusinessException e) {
			return Message.failure(e.getErrorCode(),e.getMessage(),null);
		}
	 }
	

	/**
	 * 手机验证码预检
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "checkCodeMsg.do", method = RequestMethod.POST)
	public Message<String> checkCodeMsg(@RequestBody VerificationCode condition) {
		//参数校验
		if(!ObjectExtend.hasSubstance(condition.getMsgCode())){
			return Message.failure(201, "验证码不能为空",null);
		}

		String token=request.getHeader(RequestConstant.TOKEN);
		SessionViewAppearance init=new SessionViewAppearance(token);
		SessionViewAppearance pre=service.view(init);
		Session session=pre.getSession();
		
		//校验验证码
		VerificationCode codeModelSession=session.getCode();
		if (!condition.getMsgCode().equalsIgnoreCase(codeModelSession.getMsgCode())){
			return Message.failure(202, "手机验证码不正确",null);
		}else{
			return Message.success("手机验证码验证通过", null);
		}
			
	}
	
	
	
	

	//是否手机号
	private boolean isMobileNO(String mobiles){ 
		//String regExp = "^[1]([3][0-9]{1}|59|58|88|89)[0-9]{8}$"; 
		//String regExp = "^((13[0-9])|(15[^4,//D])|(18[0,5-9]))//d{8}$"; 
		String regExp = "^1[0-9]{10}$";
		
		
		Pattern p = Pattern.compile(regExp); 
		Matcher m = p.matcher(mobiles); 
		return m.matches(); 

	}

	
}



















