/**
 * @author zhanghaiting
 * @date 2016年3月8日
 */
package xyz.zhiwei.explorer.morphism.support.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Random;

/**
 * 随机码工具
 * @author zhanghaiting
 * @date: 2016年3月8日
 */
public class RandomCode {
	//36个字符
	static char[] codeSequence = { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
            'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',
            'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };


	static char[] numSequence = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' };
	
 
    
    /**
     * 获取N 位随机码
     * @param 随机码长度
     */
    public static String getRandomCodes(int codeCount){
        StringBuffer randomCode = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < codeCount; i++) {
            // 得到随机产生的验证码数字。
            String code = String.valueOf(codeSequence[random.nextInt(36)]);
            randomCode.append(code);
        }
		return randomCode.toString();
    }
    

    /**
     * 获取N 位随机码
     * @param 随机码长度
     */
    public static String getRandomNum(int codeCount){
        StringBuffer randomCode = new StringBuffer();
        Random random = new Random();
        for (int i = 0; i < codeCount; i++) {
            // 得到随机产生的验证码数字。
            String code = String.valueOf(numSequence[random.nextInt(10)]);
            randomCode.append(code);
        }
		return randomCode.toString();
    }
    
    
    
    
    
    
    /**
     * 由随机码生成 图片
     * @author zhanghaiting
     * @date 2016年3月8日
     * @parameter
     * @return
     */
    public static BufferedImage getPicForCodes(String codes){

	    int width = 70;//定义图片的width
	    int height = 26;//定义图片的height
	    int xx = 13;//字符间距
	    int fontHeight = 20; //字体大小
	    int codeY = 22;//字体位置 高
	    
        // 定义图像buffer
        BufferedImage buffImg = new BufferedImage(width, height,
                BufferedImage.TYPE_INT_RGB);
//      Graphics2D gd = buffImg.createGraphics();
        //Graphics2D gd = (Graphics2D) buffImg.getGraphics();
        Graphics gd = buffImg.getGraphics();
        // 创建一个随机数生成器类
        Random random = new Random();
        // 将图像填充为白色
        gd.setColor(Color.WHITE);
        gd.fillRect(0, 0, width, height);
 
        // 创建字体，字体的大小应该根据图片的高度来定。
        Font font = new Font("Fixedsys", Font.BOLD, fontHeight);
        // 设置字体。
        gd.setFont(font);
 
        // 画边框。
        gd.setColor(Color.BLACK);
        gd.drawRect(0, 0, width - 1, height - 1);
 
        // 随机产生40条干扰线，使图象中的认证码不易被其它程序探测到。
        gd.setColor(Color.BLACK);
        for (int i = 0; i < 20; i++) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            gd.drawLine(x, y, x + xl, y + yl);
        }
 
        // randomCode用于保存随机产生的验证码，以便用户登录后进行验证。
        int red = 0, green = 0, blue = 0;
 
        // 随机产生codeCount数字的验证码。
        for (int i = 0; i < codes.length(); i++) {
            // 得到随机产生的验证码数字。
            String code = codes.substring(i, i+1);
            // 产生随机的颜色分量来构造颜色值，这样输出的每位数字的颜色值都将不同。
            red = random.nextInt(255);
            green = random.nextInt(255);
            blue = random.nextInt(255);
 
            // 用随机产生的颜色将验证码绘制到图像中。
            gd.setColor(new Color(red, green, blue));
            gd.drawString(code, (i + 1) * xx, codeY);
 
        }
        
		return buffImg;
	    
    }
}
