package xyz.zhiwei.explorer.morphism.support.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.apache.commons.lang3.reflect.ConstructorUtils;

/**
 * @author:Aureole
 * @date:2016年11月30日
 */
public class ObjectReflect {


    /**
     * 获取 Model里的属性
     * @param model
     * @param attributeName
     * @param value
     */
    public static <T> String getModelAttributeString(T model,String attributeName){
		String getMethodName="get"+ObjectExtend.upperCase(attributeName);

		//获取属性的值
		Object valueObj=getModelMethodReturn(model, getMethodName);
		String valStr=null;
		if(null!=valueObj && valueObj instanceof String){
			valStr= (String) valueObj;
		}
		return valStr;
    }
    
    /**
     * 设置 Model里的属性
     * @param model
     * @param attributeName
     * @param value
     */
    public static <T> void setModelAttribute(T model,String attributeName,String value){
		String setMethodName="set"+ObjectExtend.upperCase(attributeName);
        invokeMethod(model, setMethodName, new Class<?>[]{String.class}, new Object[]{value});
    }
    
    
    /**
     * 在model中根据方法名称返回方法的返回值
     */
    public static <T> Object getModelMethodReturn(T model, String methodName) {

        //Class<? extends Object> modelClass = model.getClass();
        Method method = null;
        Object velObj = null;
        try {
            //method = modelClass.getDeclaredMethod(methodName);
            method = getDeclaredMethod(model,methodName);
            
            if(null==method){
            	return null;
            }
            
            velObj = method.invoke(model);

//        } catch (NoSuchMethodException e1) {
//            e1.printStackTrace();
        } catch (SecurityException e1) {
            e1.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return velObj;
    }

    
    /** 
     * 直接调用对象方法, 而忽略修饰符(private, protected, default) 
     * @param object : 子类对象 
     * @param methodName : 父类中的方法名 
     * @param parameterTypes : 父类中的方法参数类型 
     * @param parameters : 父类中的方法参数 
     * @return 父类中方法的执行结果 
     */  
      
    public static Object invokeMethod(Object object, String methodName, Class<?> [] parameterTypes,  
            Object [] parameters) {  
        //根据 对象、方法名和对应的方法参数 通过反射 调用上面的方法获取 Method 对象  
        Method method = getDeclaredMethod(object, methodName, parameterTypes) ;  
          
        //抑制Java对方法进行检查,主要是针对私有方法而言  
        method.setAccessible(true) ;  
          
            try {  
                if(null != method) {  
                      
                    //调用object 的 method 所代表的方法，其方法的参数是 parameters  
                    return method.invoke(object, parameters) ;  
                }  
            } catch (IllegalArgumentException e) {  
                e.printStackTrace();  
            } catch (IllegalAccessException e) {  
                e.printStackTrace();  
            } catch (InvocationTargetException e) {  
                e.printStackTrace();  
            }  
          
        return null;  
    }  
    
	
    /** 
     * 循环向上转型, 获取对象的 DeclaredMethod 
     * @param object : 子类对象 
     * @param methodName : 父类中的方法名 
     * @param parameterTypes : 父类中的方法参数类型 
     * @return 父类中的方法对象 
     */  
      
    public static Method getDeclaredMethod(Object object, String methodName, Class<?> ... parameterTypes){  
        Method method = null ;  
          
        for(Class<?> clazz = object.getClass() ; clazz != Object.class ; clazz = clazz.getSuperclass()) {  
            try {  
                method = clazz.getDeclaredMethod(methodName, parameterTypes) ;  
                return method ;  
            } catch (Exception e) {  
            	//e.printStackTrace();
                //这里甚么都不要做！并且这里的异常必须这样写，不能抛出去。  
                //如果这里的异常打印或者往外抛，则就不会执行clazz = clazz.getSuperclass(),最后就不会进入到父类中了  
              
            }  
        }  
          
        return null;  
    } 
	
	
	/**
	 * 实例化一个类
	 */
    public static <T> T createTmodel(Class<T> clazz) {
        try {
            return ConstructorUtils.invokeConstructor(clazz);
        } catch (Exception e) {
            throw new RuntimeException("Failed to create instance", e);
        }
    }
	
    public static String getModelAttribute(){
		return null;
    }
	


}
