package xyz.zhiwei.explorer.morphism.support.facet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSourcePage;

/**
 * 分页
 * 简化自com.github.pagehelper.PageSerializable
 * @param <E>
 */
public class Page<E> implements Serializable {
    private static final long serialVersionUID = 1L;
    //结果集
    protected List<E> list;
    //总数
    private Long total;
    

	public Page(){}

	public Page(List<E> list){
		this.list=list;
		setTotal(list);
	}
	
	
	public Page(List<E> list,Long total){
		this.list=list;
		setTotal(list);
		if(null!=total) {
			this.total=total;
		}
	}
	
	private void setTotal(List<E> list) {
		if(null==list) {
			this.total=0L;
			return;
		}
		if(list instanceof PrincipleSourcePage) {
			PrincipleSourcePage<?> principleSourcePage=(PrincipleSourcePage<?>)list;
			this.total=principleSourcePage.getTotal();
			return;
		}
		this.total=Long.valueOf(list.size());
	}
	
	
	
	public boolean add(E e) {
		if(null==this.list) {
			this.list=new ArrayList<>();
		}
		return this.list.add(e);
	}
	
	public boolean addAll(List<E> list) {
		if(null==this.list) {
			this.list=new ArrayList<>();
		}
		return this.list.addAll(list);
	}

	
	
	
	
	
	public List<E> getList() {
		return list;
	}

	public void setList(List<E> list) {
		this.list = list;
	}

	public Long getTotal() {
		return total;
	}

	public void setTotal(Long total) {
		this.total = total;
	}
	
	



	
}