package xyz.zhiwei.explorer.morphism.support.constant;

/**
 * 表名与表ID的映射枚举类
 * 用于雪花算法生成ID时指定对应的表标识
 */
public enum TableIdEnum {

    // 用户表 - ID: 1
    EXPLORER(1, "explorer"),

    // 联系人表 - ID: 2
    LINKMAN(2, "linkman"),
    
    // 私信表 - ID: 3
    LETTER(3, "letter");
    
    /**
     * 表ID（用于雪花算法）
     */
    private final int tableId;
    
    /**
     * 数据库表名
     */
    private final String tableName;

    /**
     * 构造函数
     * @param tableId 表ID
     * @param tableName 表名
     */
    TableIdEnum(int tableId, String tableName) {
        // 校验表ID是否在有效范围内（0-127）
        if (tableId < 0 || tableId > 127) {
            throw new IllegalArgumentException("表ID必须在0-127之间");
        }
        this.tableId = tableId;
        this.tableName = tableName;
    }

    /**
     * 获取表ID
     */
    public int getTableId() {
        return tableId;
    }

    /**
     * 获取表名
     */
    public String getTableName() {
        return tableName;
    }

    /**
     * 根据表名获取对应的枚举
     * @param tableName 表名
     * @return 对应的枚举实例，若不存在则返回null
     */
    public static TableIdEnum getByTableName(String tableName) {
        for (TableIdEnum table : values()) {
            if (table.tableName.equalsIgnoreCase(tableName)) {
                return table;
            }
        }
        return null;
    }

    /**
     * 根据表ID获取对应的枚举
     * @param tableId 表ID
     * @return 对应的枚举实例，若不存在则返回null
     */
    public static TableIdEnum getByTableId(int tableId) {
        for (TableIdEnum table : values()) {
            if (table.tableId == tableId) {
                return table;
            }
        }
        return null;
    }
}

