package xyz.zhiwei.explorer.morphism.principle.explorer.qualify;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.explorer.morphism.principle.article.model.Contribution;
import xyz.zhiwei.explorer.morphism.principle.base.qualify.BaseQualify;
import xyz.zhiwei.explorer.morphism.principle.base.qualify.FkQualify;
import xyz.zhiwei.explorer.morphism.principle.base.qualify.PkListQualify;
import xyz.zhiwei.explorer.morphism.principle.base.qualify.PkQualify;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;

/**
 * 探索者限定器
 */
public class ExplorerQualify extends BaseQualify<Explorer> implements
															PkQualify<Long,Explorer>,
															PkListQualify<Explorer>,
															FkQualify<Explorer>{

	public static final ExplorerQualify PQ=new ExplorerQualify();
	private static final String DESC_Fk_WithSensitive="fkWithSensitive";
	
	
	
	/**
	 * 子集限定符：Fk查询带敏感字段（登录校验）
	 * @return
	 */
	public PrincipleQualifier<Explorer> fkWithSensitive(Explorer explorer){
        PrincipleQualifier<Explorer> pq=new PrincipleQualifier<>(Explorer.class,explorer);
        pq.setDescribe(DESC_Fk_WithSensitive);
        return pq;
	}
	
	
	
	/**
	 * 子集限定符：贡献列表里的探索者
	 * @return
	 */
	public PrincipleQualifier<Explorer> contributionList(List<Contribution> contributionList){
		List<Explorer> idList=contributionList.stream()
				.map(c -> new Explorer(c.getExplorerId()))
				.collect(Collectors.toList());

		return pkList(idList);
	}
	
	/**
	 * 子集限定符：ID列表
	 * @return
	 */
	public PrincipleQualifier<Explorer> principleList(List<Principle<Long>> principleList){
		List<Explorer> idList=principleList.stream()
				.map(c -> new Explorer(c.getId()))
				.collect(Collectors.toList());

		return pkList(idList);
	}

}
