package xyz.zhiwei.explorer.morphism.principle.explorer.model;

import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.explorer.morphism.principle.base.model.VerificationCode;
import xyz.zhiwei.explorer.morphism.support.util.DeepClone;

/**
 * 会话
 * @param <U>
 */
public class Session extends Principle<String> {
    private static final long serialVersionUID = 1L;
    private Explorer user;
    private VerificationCode code;

    public Session() {
    }

    public Session(String id) {
        this.id = id;
    } 
    
    public Session(Explorer user) {
        this.user = user;
    }

    public Session(String id,Explorer user) {
        this.id = id;
        if(null!=user) {
        	Explorer userDp=DeepClone.deepClone(user);
        	userDp.setPassword(null);
            this.user = userDp;
        }else {
            this.user = null;
        }
    }
    
    
    /**
     * 混和入参的用户，返回新session
     * @param user
     * @return
     */
    public Session mixSession(Explorer user) {
    	Session copySession=DeepClone.deepClone(this);
    	Explorer existExplorer=copySession.getUser();
    	if(null!=user.getName()) {
    		existExplorer.setName(user.getName());
    	}
    	if(null!=user.getSignature()) {
    		existExplorer.setSignature(user.getSignature());
    	}

    	if(null!=user.getPortrait()) {
    		existExplorer.setPortrait(user.getPortrait());
    	}
    	return copySession;
    }
    
    /**
     * 混和入参的验证码，返回新session
     * @param user
     * @return
     */
    public Session mixSession(VerificationCode code) {
    	Session copySession=DeepClone.deepClone(this);
    	copySession.setCode(code);
    	return copySession;
    }
    
    
    public Explorer getUser() {
        return this.user;
    }

    
    
    public void setUser(Explorer user) {
        if(null!=user) {
        	Explorer userDp=DeepClone.deepClone(user);
        	userDp.setPassword(null);
            this.user = userDp;
        }else {
            this.user = null;
        }
    }

	public VerificationCode getCode() {
		return code;
	}

	public void setCode(VerificationCode code) {
		this.code = code;
	}
}
