package xyz.zhiwei.explorer.morphism.principle.base.qualify;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

import xyz.zhiwei.cognitivedesign.morphism.Principle;

/**
 * 限定符基础：指定类型
 * @param <P>
 */
public abstract class BaseQualify<P extends Principle<?>> implements BaseQualifyInterface<P>{

	protected  Class<P> genericityClazz;
	
	/**
	 * 获取泛型的类型
	 */
	@SuppressWarnings("unchecked")
	@Override
	public Class<P> getgenericityClass() {
		if(null==this.genericityClazz){
	        Type genType = this.getClass().getGenericSuperclass();
	        Type[] params = ((ParameterizedType) genType).getActualTypeArguments();
	        this.genericityClazz = (Class<P>) params[0];
		}
		return this.genericityClazz;
    }
	
	
}
