package xyz.zhiwei.explorer.morphism.principle.article.model;

import xyz.zhiwei.cognitivedesign.morphism.Principle;

public class Contribution extends Principle<Long>{
	private static final long serialVersionUID = 7786879074422942419L;

	private Long conceptId;

    private Long explorerId;

    
    private Integer grade=0;

    private Integer contribution=0;

    private Integer wait=0;

    private Integer refuse=0;
    
    
    public Contribution() {}
    public Contribution(Long id) {
    	setId(id);
    }

    public Contribution(Long conceptId,Long explorerId) {
    	setConceptId(conceptId);
    	setExplorerId(explorerId);
    }
    
    
    public String uniqueKey() {
    	if(null==conceptId || null==explorerId) {
    		return null;
    	}
    	return String.valueOf(conceptId)+"_"+String.valueOf(explorerId);
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Integer getContribution() {
        return contribution;
    }

    public void setContribution(Integer contribution) {
        this.contribution = contribution;
    }

    public Integer getWait() {
        return wait;
    }

    public void setWait(Integer wait) {
        this.wait = wait;
    }

    public Integer getRefuse() {
        return refuse;
    }

    public void setRefuse(Integer refuse) {
        this.refuse = refuse;
    }

	public Long getConceptId() {
		return conceptId;
	}

	public void setConceptId(Long conceptId) {
		this.conceptId = conceptId;
	}

	public Long getExplorerId() {
		return explorerId;
	}

	public void setExplorerId(Long explorerId) {
		this.explorerId = explorerId;
	}

}