package xyz.zhiwei.explorer.morphism.appearance.shortmessage.register;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.facet.shortmessage.ShortMessageCodeInit;
import xyz.zhiwei.explorer.morphism.facet.shortmessage.ShortMessageFacet;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.ShortMessage;
import xyz.zhiwei.explorer.morphism.support.constant.SortMsgConstant;
import xyz.zhiwei.explorer.morphism.support.exception.BusinessException;
import xyz.zhiwei.explorer.morphism.support.util.RandomCode;

/**
 * 用户注册验证码
 */
public class ShortMessageRegisterAppearance extends SessionAppearance{

	//init
    private ShortMessageCodeInit init;

    //=============原象=============
    //session
    private Session session;

    //=============构造=============
    //短信本身
    private ShortMessageFacet shortMessageFacet;

    //=============映象=============
    //短信本身
    private ShortMessage shortMessage;
    //更新session
    private Session sessionUpdate;


    //初始化
	public ShortMessageRegisterAppearance(String token,ShortMessageCodeInit init) {
		super(token);
		this.init=init;
	}
	
	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
	
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//检查会话
		this.session=this.sessionSource.getSession();
        if (null==this.session) {
            throw new BusinessException(202, "用户会话不存在");
        }
		
        //检查图片验证码
		if (!this.init.getPicCode().equalsIgnoreCase(this.sessionSource.getVerificationCode().getPicCode())){
            throw new BusinessException(202, "图片验证码不正确");
		}

		//检查上次生成的验证码时间
		Date preTime=this.sessionSource.getVerificationCode().getTime();
		if(null!=preTime){
			Date now=new Date();
			if(now.getTime()-preTime.getTime()<=60*1000){
	            throw new BusinessException(206, "验证码频繁，请稍后再试。");
			}
		}

		//短信本身
		this.shortMessageFacet=new ShortMessageFacet(SortMsgConstant.MSG_Register,this.init.getPhone(),RandomCode.getRandomNum(6));
		
        return this;
	};

	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    //短信本身
	    this.shortMessage=this.shortMessageFacet;
		//会话记录所发送短信的code
	    this.sessionUpdate=this.session.mixSession(this.shortMessageFacet.getVerificationCode());
	    
		//======组成返回值======
		List<List<? extends Principle<?>>> addition=List.of(
        		Arrays.asList(this.shortMessage));
		
		List<List<? extends Principle<?>>> modification=List.of(
        		Arrays.asList(this.sessionUpdate));
		
		return new PrincipleImage(addition,modification);
	}
	
}
