package xyz.zhiwei.explorer.morphism.appearance.shortmessage.login;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.facet.shortmessage.ShortMessageCodeInit;
import xyz.zhiwei.explorer.morphism.facet.shortmessage.ShortMessageFacet;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.ShortMessage;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.explorer.morphism.support.constant.SortMsgConstant;
import xyz.zhiwei.explorer.morphism.support.exception.BusinessException;
import xyz.zhiwei.explorer.morphism.support.util.RandomCode;

/**
 * 用户登录验证码
 */
public class ShortMessageLoginAppearance extends SessionAppearance{

	//init
    private ShortMessageCodeInit init;

    //=============原象=============
    private Source source;
    //session
    private Session session;
    //手机号已注册用户
    private Explorer telExistExplorer;

    //=============构造=============
    //短信本身
    private ShortMessageFacet shortMessageFacet;

    //=============映象=============
    //短信本身
    private ShortMessage shortMessage;
    //更新session
    private Session sessionUpdate;


    //初始化
	public ShortMessageLoginAppearance(String token,ShortMessageCodeInit init) {
		super(token);
		this.init=init;
	}
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	PrincipleQualifiers principleQualifiers=super.qualifierGroup1st(principleSourceList);
    	
    	//手机号查询
    	PrincipleQualifier<Explorer> telQualifier=ExplorerQualify.PQ.fk(new Explorer(null,this.init.getPhone()));

		return principleQualifiers.addOne(telQualifier);
	};
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.source=new Source(principleSourceList);
		this.session=this.source.getSession();
		this.telExistExplorer=this.source.telphoneExist();
		

		//检查会话
        if (null==this.session) {
            throw new BusinessException(202, "用户会话不存在");
        }
		
        //检查图片验证码
		if (!this.init.getPicCode().equalsIgnoreCase(this.source.getVerificationCode().getPicCode())){
            throw new BusinessException(202, "图片验证码不正确");
		}

		//校验手机号是否已注册
		if(null==this.telExistExplorer) {
            throw new BusinessException(205, "该手机号未注册");
		}
		
		
		//检查上次生成的验证码时间
		Date preTime=this.source.getVerificationCode().getTime();
		if(null!=preTime){
			Date now=new Date();
			if(now.getTime()-preTime.getTime()<=60*1000){
	            throw new BusinessException(206, "验证码频繁，请稍后再试。");
			}
		}

		//短信本身
		this.shortMessageFacet=new ShortMessageFacet(SortMsgConstant.MSG_Login,this.init.getPhone(),RandomCode.getRandomNum(6));
		
        return this;
	};

	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    //短信本身
	    this.shortMessage=this.shortMessageFacet;
		//会话记录所发送短信的code
	    this.sessionUpdate=this.session.mixSession(this.shortMessageFacet.getVerificationCode());
	    
		//======组成返回值======
		List<List<? extends Principle<?>>> addition=List.of(
        		Arrays.asList(this.shortMessage));
		
		List<List<? extends Principle<?>>> modification=List.of(
        		Arrays.asList(this.sessionUpdate));
		
		return new PrincipleImage(addition,modification);
	}
	
}
