package xyz.zhiwei.explorer.morphism.appearance.session.logoncode;

import java.util.Arrays;
import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.ExplorerQualify;

/**
 * 验证码登录
 */
public class SessionLoginByCodeAppearance extends SessionAppearance{

	//init
    private LoginByCodeInit init;

    //=============原象=============
    private Source source;
    //登录session
    private Session session;
    //手机号已存在
    private List<Explorer> telExistList;
    
    //=============构造=============
    //会话本身
    private SessionCreateFacet sessionFacet;
    

    //=============映象=============
    //会话
    private Session upSession;



    //初始化
	public SessionLoginByCodeAppearance(String token,LoginByCodeInit init) {
		super(token);
		this.init=init;
	}
	

	

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	PrincipleQualifiers principleQualifiers=super.qualifierGroup1st(principleSourceList);
    	//手机号查询
    	PrincipleQualifier<Explorer> telQualifier=ExplorerQualify.PQ.fk(new Explorer(null,this.init.getTelphone()));

		return principleQualifiers.addOne(telQualifier);
	};
	
	
	
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.source=new Source(principleSourceList);
		this.session=this.source.getSession();
		this.telExistList=this.source.telphoneExist();
		
	    //会话本身
		this.sessionFacet=new SessionCreateFacet(this.telExistList,this.source.getVerificationCode(),this.init,this.session.getId());
		
        return this;
	};

	
	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    this.upSession=this.sessionFacet.getUpSession();
		
		//======组成返回值======
		List<List<? extends Principle<?>>> modification=List.of(
        		Arrays.asList(this.upSession));
		
		return new PrincipleImage(null,modification);
	}

	
	public SessionCreateFacet getSessionFacet() {
		return sessionFacet;
	}

	
	
	
	
}
