package xyz.zhiwei.explorer.morphism.appearance.session.logoncode;

import java.util.List;

import xyz.zhiwei.explorer.morphism.principle.base.model.VerificationCode;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.support.exception.BusinessException;

/**
 * 新建会话
 */
public class SessionCreateFacet {
	
	private Session upSession;

	
	SessionCreateFacet(List<Explorer> telExistList,VerificationCode verificationCode,LoginByCodeInit init,String sessionId) {
		
		//校验验证码时的手机号
		if ( !verificationCode.getPhone().equals(init.getTelphone())){
            throw new BusinessException(204, "非验证码手机号");
		}
		
		//校验验证码
		if ( !verificationCode.getMsgCode().equalsIgnoreCase(init.getSignature())){
            throw new BusinessException(203, "手机验证码不正确");
		}
		
		Explorer loginExplorer=telExistList.stream().findFirst().orElse(null);
        if (null==loginExplorer) {
            throw new BusinessException(201, "用户不存在");
        }

		this.upSession=new Session(sessionId,loginExplorer);
		
		
	}


	public Session getUpSession() {
		return upSession;
	}


	


}
