package xyz.zhiwei.explorer.morphism.appearance.session.login;

import java.util.Arrays;
import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.ExplorerQualify;

/**
 * 登录
 */
public class SessionLoginAppearance implements Appearance{

	//init
    private SessionLoginInit init;

    //=============原象=============
    private Source source;
    //名号已存在
    private List<Explorer> nameExistList;
    //手机号已存在
    private List<Explorer> telExistList;
    
    //=============构造=============
    //会话本身
    private SessionCreateFacet sessionFacet;
    

    //=============映象=============
    //会话
    private Session session;



    //初始化
	public SessionLoginAppearance(SessionLoginInit init) {
		this.init=init;
	}
	

	

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	
    	//名号查询
    	PrincipleQualifier<Explorer> nameQualifier=ExplorerQualify.PQ.fkWithSensitive(new Explorer(this.init.getName()));
    	//手机号查询
    	PrincipleQualifier<Explorer> telQualifier=ExplorerQualify.PQ.fkWithSensitive(new Explorer(null,this.init.getName()));

		return new PrincipleQualifiers(nameQualifier,telQualifier);
	};
	
	
	
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.source=new Source(principleSourceList);
		this.nameExistList=this.source.nameExist();
		this.telExistList=this.source.telphoneExist();
	    //会话本身
		this.sessionFacet=new SessionCreateFacet(this.nameExistList,this.telExistList,this.init);
		
        return this;
	};

	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    this.session=this.sessionFacet.getNewSession();
		
		//======组成返回值======
		List<List<? extends Principle<?>>> addition=List.of(
				Arrays.asList(this.session));
		
		return new PrincipleImage(addition);
	}

	
	public SessionCreateFacet getSessionFacet() {
		return sessionFacet;
	}

	
	
	
	
}
