package xyz.zhiwei.explorer.morphism.appearance.session.login;

import java.util.List;
import java.util.UUID;

import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.support.util.CipherMD5;

/**
 * 新建会话
 */
public class SessionCreateFacet {
	
	private Session newSession;

	
	SessionCreateFacet(List<Explorer> nameExistList,List<Explorer> telExistList,SessionLoginInit init) {
		Explorer loginExplorer=null;
		loginExplorer=nameExistList.stream().findFirst().orElse(null);
		if(null==loginExplorer) {
			loginExplorer=telExistList.stream().findFirst().orElse(null);
		}
		
		if(null==loginExplorer) {
			return;
		}
		
		String mdPassword = CipherMD5.encodeByMD5(init.getPassword());
		if(!loginExplorer.getPassword().equals(mdPassword)) {
			return;
		}

		String id=UUID.randomUUID().toString();
		Session newSession=new Session(id,loginExplorer);
		
		this.newSession=newSession;
		
		
	}


	
	public Session getNewSession() {
		return newSession;
	}



	


}
