package xyz.zhiwei.explorer.morphism.appearance.session.delete;

import java.util.Arrays;
import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;

/**
 * 清空session
 */
public class SessionDeleteAppearance extends SessionAppearance{

	//init
    //private String token;

    //=============原象=============
    //this.sessionSource
    

    //=============映象=============
	private Session delSession;


    //初始化
	public SessionDeleteAppearance(String token) {
		super(token);
	}
	

	
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
    	this.sessionSource=new SessionSource(principleSourceList);
        return this;
	};

	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    this.delSession=this.sessionSource.getSession();
		
		//======组成返回值======
		List<List<? extends Principle<?>>> deletion=List.of(
        		Arrays.asList(this.delSession));
		
		return new PrincipleImage(null,null,deletion);
	}


	
	
}
