package xyz.zhiwei.explorer.morphism.appearance.session.create;

import java.util.Arrays;
import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;

/**
 * 创建session,图片验证码前使用
 */
public class SessionCreateAppearance extends SessionAppearance{

	//init
    //private String token;

    //=============原象=============
    //this.sessionSource
    
    //=============构造=============
    private SessionCreateFacet sessionFacet;

    //=============映象=============
	private Session newSession;


    //初始化
	public SessionCreateAppearance(String token) {
		super(token);
	}
	

	
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
    	this.sessionSource=new SessionSource(principleSourceList);

    	this.sessionFacet=new SessionCreateFacet(this.sessionSource.getSession());
		
        return this;
	};

	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    this.newSession=this.sessionFacet.getNewSession();
		
		//======组成返回值======
		List<List<? extends Principle<?>>> addition=List.of(
				Arrays.asList(this.newSession));
		
		return new PrincipleImage(addition);
	}



	public SessionCreateFacet getSessionFacet() {
		return sessionFacet;
	}

	
	
	
	
}
