package xyz.zhiwei.explorer.morphism.appearance.session.code;

import java.util.Arrays;
import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;

/**
 * 生成图片code,存入session
 */
public class SessionCodeAppearance extends SessionAppearance{

	//init
    //private String token;

    //=============原象=============
    //this.sessionSource
    
    //=============构造=============
    private SessionCodeFacet sessionFacet;

    //=============映象=============
	private Session upSession;


    //初始化
	public SessionCodeAppearance(String token) {
		super(token);
	}
	

	
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
    	this.sessionSource=new SessionSource(principleSourceList);

    	this.sessionFacet=new SessionCodeFacet(this.sessionSource.getSession());
		
        return this;
	};

	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    this.upSession=this.sessionFacet.getSession();
		
		//======组成返回值======
		List<List<? extends Principle<?>>> modification=List.of(
        		Arrays.asList(this.upSession));
		
		return new PrincipleImage(null,modification);
	}

	public SessionCodeFacet getSessionFacet() {
		return sessionFacet;
	}

	
	
	
	
}
