package xyz.zhiwei.explorer.morphism.appearance.session.base;

import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.principle.base.model.VerificationCode;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;

/**
 * 带session的原集
 */
public class SessionSource {


	/**
	 * List<PrincipleSource>
	 * 0: [List<Session>]
	 */
	protected List<PrincipleSource> principleSourceList;
	
	public SessionSource(List<PrincipleSource> principleSourceList) {
		this.principleSourceList=principleSourceList;
	}
	
	/**
	 * Session
	 * @return
	 */
	public Session getSession() {
		@SuppressWarnings("unchecked")
		List<Session> list=(List<Session>) this.principleSourceList.getFirst().getFirst();
		return list.isEmpty() ? null : list.get(0);
	}
	
	
	/**
	 * 登录用户
	 * @return
	 */
	public Explorer getLoginUser() {
	    Session session=getSession();
	    if(null!=session) {
		    return session.getUser();
	    }
	    return null;
	}
	

	/**
	 * 验证码
	 * @return
	 */
	public VerificationCode getVerificationCode() {
	    Session session=getSession();
	    if(null!=session) {
		    return session.getCode();
	    }
	    return null;
	}
	
	
}
