package xyz.zhiwei.explorer.morphism.appearance.session.base;

import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.SessionQualify;

/**
 * 带session的表象
 */
public class SessionAppearance implements Appearance{

	//init
    private String token;
    

    //=============原象=============
    protected SessionSource sessionSource;
    //登录用户
    protected Explorer loginUser;
	
    
    
    
    //初始化
	public SessionAppearance(String token) {
		this.token=token;
	}

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询：查session
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	//session
    	PrincipleQualifier<Session> sessionQualifier=SessionQualify.PQ.pk(this.token);

		return new PrincipleQualifiers(sessionQualifier);
	};
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第二次查询
	 * 
	 * @param principleSourceList
	 * @return
	 */
	protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.sessionSource=new SessionSource(principleSourceList);
    	this.loginUser=this.sessionSource.getLoginUser();
		return null;
	};
	
}
