package xyz.zhiwei.explorer.morphism.appearance.linkman.page;

import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionSource;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;

/**
 * 原象集
 */
class Source extends SessionSource{
	
	
	/**
	 * ---------super------------
	 * 0: [List<Session>]
	 * ---------------------------
	 * 
	 * List<PrincipleSource>
	 * 1: [联系人列表    ] 
	 * 1: [List<Linkman>] 
	 * 
	 * 2: [联系人详情列表]
	 * 2: [List<Explorer>]
	 * 
	 * 
	 */
	//private List<PrincipleSource> principleSourceList;
	
	Source(List<PrincipleSource> principleSourceList) {
		super(principleSourceList);
	}

	
	
	/**
	 * 联系人列表
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Linkman> getLinkmanList(){
	    return (List<Linkman>) principleSourceList.get(1).get(0); 
	}
	
	
	/**
	 * 联系人详情列表
	 * @return
	 */
	@SuppressWarnings("unchecked")
	List<Explorer> getExplorerList() {
	    return (List<Explorer>) principleSourceList.get(2).get(0);
	}
}
