package xyz.zhiwei.explorer.morphism.appearance.linkman.page;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.LinkmanQualify;
import xyz.zhiwei.explorer.morphism.support.facet.PageCondition;

/**
 * 限定符生成器
 */
class Qualify {

	
	
	/**
	 * 联系人列表
	 * @param condition
	 * @return
	 */
	static PrincipleQualifier<Linkman> page(PageCondition<Date> condition,Long explorerId){
		Linkman similar=new Linkman();
		similar.setExplorerId(explorerId);
		similar.setUpdateTime(condition.getSimilar());
		PageCondition<Linkman> linkmanCondition=new PageCondition<>(similar,condition.getPageNum(),condition.getPageSize());
		
    	return LinkmanQualify.PQ.page(linkmanCondition);
	}
	
	/**
	 * 子集限定符：联系人列表里的探索者
	 * @param linkmanList
	 * @return
	 */
	static PrincipleQualifier<Explorer> linkmanList(List<Linkman> linkmanList){
		List<Explorer> idList=linkmanList.stream()
				.map(c -> new Explorer(c.getLinkmanId()))
				.collect(Collectors.toList());

		return ExplorerQualify.PQ.pkList(idList);
	}
	
	
	
	
}
