package xyz.zhiwei.explorer.morphism.appearance.linkman.page;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.support.facet.PageCondition;

/**
 * 联系人分页
 */
public class LinkmanPageAppearance extends SessionAppearance{

	//init
    private PageCondition<Date> initUpdateTime;

    //=============原象=============
    private Source source;
    //联系人列表
    private List<Linkman> linkmanList;
    //关联的探索者列表
    private List<Explorer> explorerList;
	

    //=============构造=============
	//贡献者分页
    private LinkmanExplorerPage page;
    

    //初始化
	public LinkmanPageAppearance(String token,PageCondition<Date> init) {
		super(token);
		this.initUpdateTime=init;
	}

	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd,this::qualifierGroup3rd);
	}
    

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);

		//核心集定义：联系人列表
    	PrincipleQualifier<Linkman> coreQualifier=Qualify.page(this.initUpdateTime,this.loginUser.getId());
		
		return new PrincipleQualifiers(coreQualifier);
	};

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup3rd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.linkmanList=this.source.getLinkmanList();

		//关联集：作者信息
    	PrincipleQualifier<Explorer> explorerQualifier=Qualify.linkmanList(this.linkmanList);
		
		return new PrincipleQualifiers(explorerQualifier);
	};

	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.explorerList=this.source.getExplorerList();
		
		//联系人分页
		this.page=new LinkmanExplorerPage(this.linkmanList,this.explorerList);

        return this;
	}


	public LinkmanExplorerPage getPage() {
		return page;
	}


    
}
