package xyz.zhiwei.explorer.morphism.appearance.linkman.add;

import java.util.List;

import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.explorer.morphism.support.util.StaticSnowflake;
/**
 * 新建联系人
 */
class LinkmanFacet extends Linkman{

	private static final long serialVersionUID = 1L;

	LinkmanFacet(List<Linkman> linkmanList,Long loginUserId,Long linkmanId) {
		//建立联系
		if(null==linkmanList || linkmanList.size()==0){
			this.setId(StaticSnowflake.generateId(1, TableIdEnum.LINKMAN.getTableId()));
			this.setUseType(3);
		}else {
			Linkman exsitLinkman=linkmanList.get(0);
			this.setId(exsitLinkman.getId());
			if(3!=exsitLinkman.getUseType()){
				this.setUseType(4);
			}else {
				this.setUseType(exsitLinkman.getUseType());
			}
			this.setUpdateTime(exsitLinkman.getUpdateTime());
		}
		
		
		this.setExplorerId(loginUserId);
		this.setLinkmanId(linkmanId);
		this.setLastText("开始对话...");
		this.setDirection(1);
		this.setReadStatus(10);
		this.setUnreadCount(0);
		
    }
    
	public Linkman getAdd() {
		if(null==getUpdateTime()) {
			return this;
		}
		return null;
	}
	
	public Linkman getUpdate() {
		if(null!=getUpdateTime()) {
			return this;
		}
		return null;
	}
}
