package xyz.zhiwei.explorer.morphism.appearance.linkman.add;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.LinkmanQualify;

/**
 * 新增联系人
 */
public class LinkmanAddAppearance extends SessionAppearance{

	//init
    private Long initLinkmanId;

    //=============原象=============
    private Source source;
    //已通讯联系人
    private List<Linkman> linkmanList;

    //=============构造=============

    //新增联系人
    private LinkmanFacet linkmanFacet;
    

    //=============映象=============
    //新增联系人
    private Linkman addLinkman;
    //更新联系人
    private Linkman updateLinkman;
    
    

    //初始化
	public LinkmanAddAppearance(String token,Long initLinkmanId) {
		super(token);
		this.initLinkmanId=initLinkmanId;
	}
	

    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);
        //已通讯联系人
        PrincipleQualifier<Linkman> linkmanQualifier=LinkmanQualify.PQ.fk(new Linkman(this.loginUser.getId(),this.initLinkmanId));

		return new PrincipleQualifiers(linkmanQualifier);
	};
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.linkmanList=this.source.linkmanList();
		
        //构成联系人
		this.linkmanFacet=new LinkmanFacet(this.linkmanList,this.loginUser.getId(),this.initLinkmanId);

        return this;
	};

	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {

		//新增联系人
		this.addLinkman=this.linkmanFacet.getAdd();
		//更新联系人
		this.updateLinkman=this.linkmanFacet.getUpdate();
	    
		//======组成返回值======
		List<List<? extends Principle<?>>> addition=List.of(
        		Arrays.asList(this.addLinkman));
		
		List<List<? extends Principle<?>>> modification=List.of(
        		Arrays.asList(this.updateLinkman));
		
		return new PrincipleImage(addition,modification);
	};
	
	
}
