package xyz.zhiwei.explorer.morphism.appearance.letter.pageupdate;

import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Letter;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.LetterQualify;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.LinkmanQualify;
import xyz.zhiwei.explorer.morphism.support.facet.PageCondition;

/**
 * 限定符生成器
 */
class Qualify {

	
	
	/**
	 * 私信分页列表
	 * @param condition
	 * @return
	 */
	static PrincipleQualifier<Letter> pageOfMine(PageCondition<LetterPageReadUpdateInit> condition,Long receiverId){
		Letter letterFK=condition.getSimilar().getCondition(receiverId);
		PageCondition<Letter> letterCondition=new PageCondition<Letter>(letterFK, condition.getPageNum(), condition.getPageSize());
		
    	return LetterQualify.PQ.pageOfMine(letterCondition);
	}
	
	
	/**
	 * 第一页查询我的联系人
	 * @param explorerId
	 * @return
	 */
	static PrincipleQualifier<Linkman> fristPageMyLinkmanQualifier(PageCondition<LetterPageReadUpdateInit> init,Long explorerId){
		if(1==init.getPageNum()) {
			return LinkmanQualify.PQ.fk(new Linkman(explorerId,null));
		}
		return null;
	}
	
	
	/**
	 * 第一页查询他的联系人
	 * @param explorerId
	 * @return
	 */
	static PrincipleQualifier<Linkman> fristPageHisLinkmanQualifier(PageCondition<LetterPageReadUpdateInit> init,Long explorerId){
		if(1==init.getPageNum()) {
			return LinkmanQualify.PQ.fk(new Linkman(init.getSimilar().getSenderId(),explorerId));
		}
		return null;
	}
	
	
}
