package xyz.zhiwei.explorer.morphism.appearance.letter.pageupdate;

import java.util.List;

import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
/**
 * 联系人
 */
class LinkmanFacet {
	
	private Linkman linkman;
	

	LinkmanFacet(List<Linkman> linkmanList,Long linkmanId,int direction){
		if(1==direction) {
			setMyLinkmanFacet(linkmanList,linkmanId);
		}
		
		
		if(2==direction) {
			setHisLinkmanFacet(linkmanList);
		}
		
	}
	
	
	/**
	 * 我的联系人
	 * @param linkmanList
	 * @param explorerId
	 * @param linkmanId
	 * @param text
	 */
	private void setMyLinkmanFacet(List<Linkman> myLinkmanList,Long linkmanId){
		Linkman existLinkman = myLinkmanList.stream()
			    .filter(linkman -> linkmanId.equals(linkman.getLinkmanId()))
			    .findFirst()
			    .orElse(null);


		if(null!=existLinkman){
			Linkman myLinkman=myLinkmanList.get(0);
			if(2==myLinkman.getDirection()){
				myLinkman.setUnreadCount(0);
			}
			this.linkman=myLinkman;
		}
	}

	
	/**
	 * 对方的联系人
	 * @param linkmanList
	 * @param explorerId
	 * @param linkmanId
	 */
	private void setHisLinkmanFacet(List<Linkman> hisLinkmanList){

		if(hisLinkmanList.size()>0){
			Linkman hisLinkman=hisLinkmanList.get(0);
			if(1==hisLinkman.getDirection() && 3!=hisLinkman.getUseType()){
				hisLinkman.setReadStatus(1);
			}
			this.linkman=hisLinkman;
		}
	}


	public Linkman getLinkman() {
		return linkman;
	}
	
	
	
}
