package xyz.zhiwei.explorer.morphism.appearance.letter.pageupdate;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.principle.explorer.imagine.LetterImagine;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Letter;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.support.facet.Page;
import xyz.zhiwei.explorer.morphism.support.facet.PageCondition;

/**
 * 查看私信(更新已读状态)
 */
public class LetterPageReadUpdateAppearance extends SessionAppearance{

	//init
    private PageCondition<LetterPageReadUpdateInit> init;

    //=============原象=============
    private Source source;
    //私信列表
    private List<Letter> letterList;
    //我的联系人列表
    private List<Linkman> myLinkmanList;
    //他的联系人列表
    private List<Linkman> hisLinkmanList;

    //=============构造=============
    //私信列表
    private Page<Letter> letterPage;
    //我的联系人
    private LinkmanFacet myLinkmanFacet;
    //他的联系人
    private LinkmanFacet hisLinkmanFacet;

    //=============变换=============
    //自己全部未读的私信数汇总更新
    private ExplorerUnreadCountFacet explorerUnreadCountFacet;

    
    //=============映象=============
    //私信已读更新
    private Letter letterReadUpdateCondition;
    //我的更新联系人
    private Linkman myUpdateLinkman;
    //他的更新联系人
    private Linkman hisUpdateLinkman;
    //他的基础信息：未读私信数
    private Explorer explorerUnreadCount;
    
    //TODO： 尝试更新在线用户的信息session


    //初始化
	public LetterPageReadUpdateAppearance(String token,PageCondition<LetterPageReadUpdateInit> init) {
		super(token);
		this.init=init;
	}
	

    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);
    	this.source=new Source(principleSourceList);

		//核心集定义：私信列表
    	PrincipleQualifier<Letter> coreQualifier=Qualify.pageOfMine(this.init,this.loginUser.getId());

        //我的联系人(全部)
        PrincipleQualifier<Linkman> myLinkmanQualifier=Qualify.fristPageMyLinkmanQualifier(this.init,this.loginUser.getId());
        //他的联系人
        PrincipleQualifier<Linkman> hisLinkmanQualifier=Qualify.fristPageHisLinkmanQualifier(this.init,this.loginUser.getId());
    	
    	
		return new PrincipleQualifiers(coreQualifier,myLinkmanQualifier,hisLinkmanQualifier);
	};
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
    	this.letterList=this.source.letterList();
    	this.myLinkmanList=this.source.myLinkmanList();
    	this.hisLinkmanList=this.source.hisLinkmanList();

        //私信列表
        this.letterPage=new Page<Letter>(this.letterList);
        //构成联系人
		this.myLinkmanFacet=new LinkmanFacet(this.myLinkmanList,this.init.getSimilar().getSenderId(),1);
		this.hisLinkmanFacet=new LinkmanFacet(this.hisLinkmanList,this.init.getSimilar().getSenderId(),2);

        return this;
	};

	
	/**
	 * 关系3：表象变化实质是本原集变化
	 */
	@Override
	public Appearance transforms() {
		
	    //自己全部未读的私信数汇总更新
	    this.explorerUnreadCountFacet=new ExplorerUnreadCountFacet(this.myLinkmanList,this.loginUser.getId(),this.init);
	    
		return this;
	}
	
	

	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    //未读的列表(要改成已读)
		this.letterReadUpdateCondition=this.init.getSimilar().getUpdateCondition(this.loginUser.getId(),this.init.getPageNum());
	    //我的更新联系人
	    this.myUpdateLinkman=this.myLinkmanFacet.getLinkman();
	    //他的更新联系人
	    this.hisUpdateLinkman=this.hisLinkmanFacet.getLinkman();
	    //我的基础信息：未读私信数
	    this.explorerUnreadCount=this.explorerUnreadCountFacet.getExplorer();
	    
	    
		
		
		//======组成返回值======
		List<List<? extends Principle<?>>> modification=List.of(
				LetterImagine.updateByFk(Arrays.asList(this.letterReadUpdateCondition)),
        		Arrays.asList(this.myUpdateLinkman,this.hisUpdateLinkman),
        		Arrays.asList(this.explorerUnreadCount));
		
		return new PrincipleImage(null,modification);
	}


	public Page<Letter> getLetterPage() {
		return letterPage;
	}

	
}
