package xyz.zhiwei.explorer.morphism.appearance.letter.pageupdate;

import java.util.List;

import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.support.facet.PageCondition;

/**
 * 探索者未读私信数
 */
class ExplorerUnreadCountFacet {
	
	private Explorer explorer;

	
	ExplorerUnreadCountFacet(List<Linkman> linkmanList,Long explorerId,PageCondition<LetterPageReadUpdateInit> init) {
		Long linkmanId=init.getSimilar().getSenderId();
		Integer pageNum=init.getPageNum();
		
    	if(1!=pageNum) {
    		return;
    	}
		
		//全部未读数=非当前联系人的未读数
		Integer explorerUnreadCount=0;
		if(null!=linkmanList){
			for (int i = 0; i < linkmanList.size(); i++) {
				Linkman linkman=linkmanList.get(i);
				if(2==linkman.getDirection()) {
					if(!linkmanId.equals(linkman.getLinkmanId())) {
						explorerUnreadCount+=linkman.getUnreadCount();
					}
				}
			}
		}

		Explorer explorer=new Explorer(explorerId);
		explorer.setLetterUnreadCount(explorerUnreadCount);
		
		this.explorer=explorer;
	}

	
	
	

	public Explorer getExplorer() {
		return explorer;
	}
}
