package xyz.zhiwei.explorer.morphism.appearance.letter.add;

import java.util.Date;
import java.util.List;

import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.support.constant.TableIdEnum;
import xyz.zhiwei.explorer.morphism.support.util.StaticSnowflake;
/**
 * 联系人
 */
class LinkmanFacet {
	private Linkman add;
	private Linkman update;
	
	
	LinkmanFacet(List<Linkman> linkmanList,Long explorerId,LetterAddInit init,int direction){
		if(1==direction) {
			setMyLinkmanFacet(linkmanList,explorerId,init.getReceiverId(),init.getText());
		}
		
		
		if(2==direction) {
			setHisLinkmanFacet(linkmanList,init.getReceiverId(),explorerId,init.getText());
		}
		
	}
	
	
	/**
	 * 我的联系人
	 * @param linkmanList
	 * @param explorerId
	 * @param linkmanId
	 * @param text
	 */
	private void setMyLinkmanFacet(List<Linkman> linkmanList,Long explorerId,Long linkmanId,String text){
		
		if(null==linkmanList || linkmanList.size()==0){
			add=new Linkman();
			add.setId(StaticSnowflake.generateId(1, TableIdEnum.LINKMAN.getTableId()));
			add.setExplorerId(explorerId);
			add.setLinkmanId(linkmanId);
			add.setLastText(text);
			add.setDirection(1);
			add.setUseType(1);
			add.setReadStatus(0);
			add.setUnreadCount(0);
			
		}else{
			update=linkmanList.get(0);
			update.setLastText(text);
			update.setDirection(1);
			update.setUseType(1);
			update.setReadStatus(0);
			update.setUpdateTime(new Date());
		}
		
	}

	
	/**
	 * 对方的联系人
	 * @param linkmanList
	 * @param explorerId
	 * @param linkmanId
	 * @param text
	 * @param i
	 */
	private void setHisLinkmanFacet(List<Linkman> linkmanList,Long explorerId,Long linkmanId,String text){
		Linkman existLinkman = linkmanList.stream()
			    .filter(linkman -> linkmanId.equals(linkman.getLinkmanId()))
			    .findFirst()
			    .orElse(null);
		
		if(null==existLinkman){

			add=new Linkman();
			add.setId(StaticSnowflake.generateId(1, TableIdEnum.LINKMAN.getTableId()));
			add.setExplorerId(explorerId);
			add.setLinkmanId(linkmanId);
			add.setLastText(text);
			add.setDirection(2);
			add.setUseType(1);
			add.setReadStatus(0);
			add.setUnreadCount(1);
			
		}else{
			update=existLinkman;
			update.setLastText(text);
			update.setDirection(2);
			update.setUseType(1);
			update.setUnreadCount(1);//TODO 此处要更新成+
			update.setUpdateTime(new Date());
		}
	}
	
	
	
	
	
	
	
	
	
	
	public Linkman getAdd() {
		return add;
	}

	public Linkman getUpdate() {
		return update;
	}

	
	
	
}
