package xyz.zhiwei.explorer.morphism.appearance.letter.add;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Letter;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Linkman;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.LinkmanQualify;

/**
 * 新增私信
 */
public class LetterAddAppearance extends SessionAppearance{

	//init
    private LetterAddInit init;

    //=============原象=============
    private Source source;
    //我的联系人列表(和他有关的)
    private List<Linkman> myLinkmanList;
    //他的联系人列表(全部)
    private List<Linkman> hisLinkmanList;

    //=============构造=============
    //私信本身
    private LetterAddFacet letterAddFacet;
    //我的联系人
    private LinkmanFacet myLinkmanFacet;
    //他的联系人
    private LinkmanFacet hisLinkmanFacet;

    //=============变换=============
    //对方全部未读的私信数汇总更新
    private ExplorerUnreadCountFacet explorerUnreadCountFacet;
    
    //=============映象=============
    //私信本身
    private Letter letter;
    //我的新增联系人
    private Linkman myAddLinkman;
    //我的更新联系人
    private Linkman myUpdateLinkman;
    //他的新增联系人
    private Linkman hisAddLinkman;
    //他的更新联系人
    private Linkman hisUpdateLinkman;
    //他的基础信息：未读私信数
    private Explorer explorerUnreadCount;
    
    //TODO： 尝试更新在线用户的信息session

    //初始化
	public LetterAddAppearance(String token,LetterAddInit init) {
		super(token);
		this.init=init;
	}
	

    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    protected PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	super.qualifierGroup2nd(principleSourceList);
        //我的联系人
        PrincipleQualifier<Linkman> myLinkmanQualifier=LinkmanQualify.PQ.fk(new Linkman(this.loginUser.getId(),this.init.getReceiverId()));
        //他的联系人
        PrincipleQualifier<Linkman> hisLinkmanQualifier=LinkmanQualify.PQ.fk(new Linkman(this.init.getReceiverId(),null));

		return new PrincipleQualifiers(myLinkmanQualifier,hisLinkmanQualifier);
	};
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.myLinkmanList=this.source.myLinkmanList();
		this.hisLinkmanList=this.source.hisLinkmanList();
		
		//私信本身
		this.letterAddFacet=new LetterAddFacet(this.init,this.loginUser.getId());
		
        //构成联系人
		this.myLinkmanFacet=new LinkmanFacet(this.myLinkmanList,this.loginUser.getId(),this.init,1);
		this.hisLinkmanFacet=new LinkmanFacet(this.hisLinkmanList,this.loginUser.getId(),this.init,2);

        return this;
	};

	
	/**
	 * 关系3：表象变化实质是本原集变化
	 */
	@Override
	public Appearance transforms() {

	    //对方全部未读的私信数汇总更新
	    this.explorerUnreadCountFacet=new ExplorerUnreadCountFacet(this.hisLinkmanList,this.init.getReceiverId());
	    
	    
		return this;
	}
	
	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    //私信本身
		this.letter=letterAddFacet;
	    //我的新增联系人
	    this.myAddLinkman=this.myLinkmanFacet.getAdd();
	    //我的更新联系人
	    this.myUpdateLinkman=this.myLinkmanFacet.getUpdate();
	    //他的新增联系人
	    this.hisAddLinkman=this.hisLinkmanFacet.getAdd();
	    //他的更新联系人
	    this.hisUpdateLinkman=this.hisLinkmanFacet.getUpdate();
	    //他的基础信息：未读私信数
	    this.explorerUnreadCount=this.explorerUnreadCountFacet;
	    
	    
		
		
		//======组成返回值======
		List<List<? extends Principle<?>>> addition=List.of(
        		Arrays.asList(this.letter),
        		Arrays.asList(this.myAddLinkman,this.hisAddLinkman));
		
		List<List<? extends Principle<?>>> modification=List.of(
        		Arrays.asList(this.myUpdateLinkman,this.hisUpdateLinkman),
        		Arrays.asList(this.explorerUnreadCount));
		
		return new PrincipleImage(addition,modification);
	}


	public Letter getLetter() {
		return letter;
	};
	
	
}
