package xyz.zhiwei.explorer.morphism.appearance.explorer.update;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.ExplorerPortrait;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.explorer.morphism.support.exception.BusinessException;

/**
 * 用户自身信息更新
 */
public class ExplorerUpdateAppearance extends SessionAppearance{

	//init
    private ExplorerUpdateInit init;

    //=============原象=============
    private Source source;
    //登录session
    private Session session;
    //名号已存在
    private List<Explorer> nameExistList;

    //=============构造=============
    //探索者本身
    private ExplorerUpdateFacet explorerUpdateFacet;

    //=============映象=============
    //探索者本身
    private Explorer explorerUpdate;
    //探索者头像
    private ExplorerPortrait explorerPortrait;
    //更新session
    private Session sessionUpdate;
    
    

    //初始化
	public ExplorerUpdateAppearance(String token,ExplorerUpdateInit init) {
		super(token);
		this.init=init;
	}
	

    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    
    
    
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	PrincipleQualifiers principleQualifiers=super.qualifierGroup1st(principleSourceList);
    	
    	//名号查询
    	PrincipleQualifier<Explorer> nameQualifier=ExplorerQualify.PQ.fk(new Explorer(this.init.getName()));

		return principleQualifiers.addOne(nameQualifier);
	};
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.source=new Source(principleSourceList);
		this.session=this.source.getSession();
		this.nameExistList=this.source.nameExist();
		
        if (!nameExistList.isEmpty()) {
        	if(!nameExistList.getFirst().getId().equals(this.loginUser.getId())) {
                throw new BusinessException(202, "用户名已存在");
        	}
        }
		
        //更新模型
		this.explorerUpdateFacet=new ExplorerUpdateFacet(this.init,this.loginUser.getId());

        return this;
	};

	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {

	    //探索者头像
	    this.explorerPortrait=this.explorerUpdateFacet.getAndSetExplorerPortrait();
	    //探索者本身
	    this.explorerUpdate=this.explorerUpdateFacet;
	    //会话更新
	    this.sessionUpdate=this.session.mixSession(this.explorerUpdate);
		
		//======组成返回值======
		List<List<? extends Principle<?>>> addition=List.of(
        		Arrays.asList(this.explorerPortrait));
		
		List<List<? extends Principle<?>>> modification=List.of(
        		Arrays.asList(this.explorerUpdate),
        		Arrays.asList(this.sessionUpdate));
		
		return new PrincipleImage(addition,modification);
	}
	
	
}
