package xyz.zhiwei.explorer.morphism.appearance.explorer.unique;

import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.ExplorerQualify;


/**
 * 查看用户名，手机号是否已存在
 */
public class ExplorerCheckUniqueAppearance implements Appearance{

	//init
    private ExplorerUniqueInit init;

    //=============原象=============
    private Source source;
    //名号已存在
    private List<Explorer> nameExistList;
    //手机号已存在
    private List<Explorer> telExistList;
    
    //=============构造=============
    //已存在的属性标记
    private ExplorerExistFacet explorerExist;
    
    
    //初始化
	public ExplorerCheckUniqueAppearance(ExplorerUniqueInit init) {
		this.init=init;
	}
	
	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询：
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {

    	//名号查询
    	PrincipleQualifier<Explorer> nameQualifier=ExplorerQualify.PQ.fk(new Explorer(this.init.getName()));
    	//手机号查询
    	PrincipleQualifier<Explorer> telQualifier=ExplorerQualify.PQ.fk(new Explorer(null,this.init.getTelphone()));

		
		return new PrincipleQualifiers(nameQualifier,telQualifier);
	};

	
	
	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.source=new Source(principleSourceList);
		this.nameExistList=this.source.nameExist();
		this.telExistList=this.source.telphoneExist();

		//已存在的信息标记探索者
		this.explorerExist=new ExplorerExistFacet(this.nameExistList,this.telExistList);
		
        return this;
	}

	
	
	
	public ExplorerExistFacet getExplorerExist() {
		return explorerExist;
	}


	
	
}