package xyz.zhiwei.explorer.morphism.appearance.explorer.register;

import java.util.Arrays;
import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImage;
import xyz.zhiwei.cognitivedesign.morphism.support.image.PrincipleImageResponse;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.explorer.morphism.appearance.session.base.SessionAppearance;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Session;
import xyz.zhiwei.explorer.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.explorer.morphism.support.exception.BusinessException;

/**
 * 用户注册
 */
public class ExplorerRegisterAppearance extends SessionAppearance{

	//init
    private ExplorerRegisterInit init;

    //=============原象=============
    private Source source;
    //登录session
    private Session session;
    //名号已存在
    private List<Explorer> nameExistList;
    //手机号已存在
    private List<Explorer> telExistList;


    //=============构造=============
    //探索者本身
    private ExplorerRegisterFacet explorerRegisterFacet;

    //=============映象=============
    //探索者本身
    private Explorer explorerRegister;
    //登录session
    private Session sessionUpdate;


    //初始化
	public ExplorerRegisterAppearance(String token,ExplorerRegisterInit init) {
		super(token);
		this.init=init;
	}
	

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {
    	PrincipleQualifiers principleQualifiers=super.qualifierGroup1st(principleSourceList);
    	
    	//名号查询
    	PrincipleQualifier<Explorer> nameQualifier=ExplorerQualify.PQ.fk(new Explorer(this.init.getName()));
    	//手机号查询
    	PrincipleQualifier<Explorer> telQualifier=ExplorerQualify.PQ.fk(new Explorer(null,this.init.getTelphone()));

		return principleQualifiers.add(nameQualifier,telQualifier);
	};
	
	
	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * @param principleSourceList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.source=new Source(principleSourceList);
		this.session=this.source.getSession();
		this.nameExistList=this.source.nameExist();
		this.telExistList=this.source.telphoneExist();


		//校验验证码时的手机号
		if (!this.init.getTelphone().equals(this.source.getVerificationCode().getPhone())){
            throw new BusinessException(204, "非验证码手机号");
		}
		//校验验证码
		if (!this.init.getSignature().equalsIgnoreCase(this.source.getVerificationCode().getMsgCode())){
            throw new BusinessException(203, "手机验证码不正确");
		}
		
        if (!this.nameExistList.isEmpty()) {
            throw new BusinessException(202, "用户名已存在");
        }
        if (!this.telExistList.isEmpty()) {
            throw new BusinessException(202, "手机号已存在");
        }

        //探索者本身
        this.explorerRegisterFacet=new ExplorerRegisterFacet(this.init);
		
        return this;
	};

	
	
	
	/**
	 * 关系2之二：本原集由表象拆解而来
	 * @return
	 */
	@Override
	public PrincipleImage deconstruct(List<PrincipleImageResponse> principleImageResponseList) {
	    //探索者本身
	    this.explorerRegister=this.explorerRegisterFacet;
	    this.sessionUpdate=new Session(this.session.getId(), this.explorerRegister);
		
		//======组成返回值======
		List<List<? extends Principle<?>>> addition=List.of(
        		Arrays.asList(this.explorerRegister));
		
		List<List<? extends Principle<?>>> modification=List.of(
        		Arrays.asList(this.sessionUpdate));
		
		return new PrincipleImage(addition,modification);
	}


    //之前的把token设在了Explorer.Password上返给前端
	public Session getSessionUpdate() {
		return sessionUpdate;
	};
	
	
}
