package xyz.zhiwei.explorer.dao.impl.rdb;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import xyz.zhiwei.cognitivedesign.dao.impl.rdb.BaseRdbDaoImpl;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.Explorer;

@Repository
public class ExplorerDaoImpl extends BaseRdbDaoImpl<Explorer> {
	
	/**
	 * 带敏感信息字段的查询
	 * @param qualifier
	 * @return
	 */
	List<Explorer> fkWithSensitive(PrincipleQualifier<Explorer> qualifier) {
        String statementName = mapperNamespace + "selectByExampleWithSensitive";
        return sqlSessionTemplate.selectList(statementName, qualifier.getSimilar());
	}
	
	@Override
    protected List<Explorer> fk(Explorer p) {
		if(null==p) {
			return null;
		}
		if(StringUtils.isAllBlank(p.getName(),p.getEmail(),p.getTelphone())) {
			return null;
		}
		return super.fk(p);
    }
}