package xyz.zhiwei.explorer.dao.impl.file;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import xyz.zhiwei.cognitivedesign.dao.Dao;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.explorer.dao.impl.file.support.Base64Image;
import xyz.zhiwei.explorer.dao.impl.file.support.FileDaoConstant;
import xyz.zhiwei.explorer.morphism.principle.explorer.model.ExplorerPortrait;

@Repository
public class ExplorerPortraitDaoImpl implements Dao<ExplorerPortrait>{

    @Autowired
    protected FileDaoImpl fileDaoImpl;

	//==========================================接口集===========================================

	@Override
	public List<ExplorerPortrait> subCollection(PrincipleQualifier<ExplorerPortrait> qualifier) {
		return null;
	}

	@Override
	public Long add(List<ExplorerPortrait> list) {
		Integer count=0;
		for(ExplorerPortrait explorerPortrait:list) {
			count+=savePortrait(explorerPortrait);
		}
		return (long)count;
	}

	@Override
	public Long update(List<ExplorerPortrait> list) {
		return add(list);
	}

	@Override
	public Long delete(List<ExplorerPortrait> list) {
		return 0L;
	}
	
	
	
	//==========================================实现===========================================


	
	/**
	 * 处理用户头像
	 * @param explorerModel
	 * @return
	 */
    private int savePortrait(ExplorerPortrait explorerPortrait){
		String imageName=explorerPortrait.getId().split(".")[0];//文件名
		
		byte[] imgByte=Base64Image.imgToByte(explorerPortrait.getName());
		if(null==imgByte){return 0;};
		
		String fileId=fileDaoImpl.upload(FileDaoConstant.DFS_M_EXPLORER, FileDaoConstant.DFS_A_PORTRAIT, imageName, "jpg", imgByte);
		
		
		if(null==fileId){
			return 0;
		}else{
		    return 1;
		}

    }

	
	
	
	
	
	
}