package xyz.zhiwei.edition.web;

import java.net.InetAddress;
import java.net.UnknownHostException;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;

@RestController
public class InfoController{

	private String version="2025-12-16";
	
	@GetMapping(value = "/info")
	public String info(HttpServletRequest request) {
	   return "Hi, I am the Article v"+version+". ip is:"+getIp();
	}
	
	@GetMapping(value = "/article/info")
	public String gateinfo(HttpServletRequest request) {
	   return "Hi, I am the Article v"+version+". ip is:"+getIp();
	}

	

    /**
       * 获取本机ip
     * @return
     */
	private String getIp(){
	      InetAddress addr;
		try {
			addr = InetAddress.getLocalHost();
		      return addr.getHostAddress();
		} catch (UnknownHostException e) {
			e.printStackTrace();
		}
		return null;
    }
}
