package xyz.zhiwei.edition.web;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import jakarta.servlet.http.HttpServletRequest;
import xyz.zhiwei.cognitivedesign.dao.Dao;
import xyz.zhiwei.cognitivedesign.morphism.Principle;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.service.Service;
import xyz.zhiwei.edition.api.EditionApi;
import xyz.zhiwei.edition.api.support.Message;
import xyz.zhiwei.edition.morphism.appearance.edition.comparison.EditionComparisonAppearance;
import xyz.zhiwei.edition.morphism.appearance.edition.comparisonlast.EditionComparisonLastAppearance;
import xyz.zhiwei.edition.morphism.appearance.edition.detail.EditionDetailAppearance;
import xyz.zhiwei.edition.morphism.appearance.edition.detail.EditionFacet;
import xyz.zhiwei.edition.morphism.appearance.edition.page.EditionExplorerFacet;
import xyz.zhiwei.edition.morphism.appearance.edition.page.EditionViewPageAppearance;
import xyz.zhiwei.edition.morphism.appearance.edition.page.EditionViewPageInit;
import xyz.zhiwei.edition.morphism.facet.edition.EditionComparisonFacet;
import xyz.zhiwei.edition.morphism.facet.edition.EditionComparisonInit;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.edition.qualify.EditionQualify;
import xyz.zhiwei.edition.morphism.support.facet.Page;
import xyz.zhiwei.edition.morphism.support.facet.PageCondition;

@RestController
@RequestMapping({"/edition"})
public class EditionController implements EditionApi{

	@Autowired
	protected HttpServletRequest request;

    @Autowired
    private Service service;
    
    @Autowired
    private Dao<Edition> editionDaoImpl;
    
    

	/**
	 * 版本基础信息
	 */
	@RequestMapping(value = "queryonesimple.do", method = RequestMethod.POST)
	@Override
	public Message<Edition> queryonesimple(@RequestBody Principle<Long> condition) {

		PrincipleQualifier<Edition> pq=EditionQualify.PQ.pk(condition.getId());
		List<Edition> list=editionDaoImpl.subCollection(pq);
		
		return Message.success(list.stream().findFirst().orElse(null));
	}
	

	/**
	 * 版本列表
	 */
	@RequestMapping(value = "queryfk.do", method = RequestMethod.POST)
	@Override
	public Message<List<Edition>> queryfk(@RequestBody Edition condition) {

		PrincipleQualifier<Edition> pq=EditionQualify.PQ.fk(condition);
		List<Edition> list=editionDaoImpl.subCollection(pq);
		
		return Message.success(list);
	}
	
	/**
	 * 上一个版本
	 */
	@RequestMapping(value = "querylastedition.do", method = RequestMethod.POST)
	@Override
	public Message<Edition> querylastedition(@RequestBody Edition condition) {

		PrincipleQualifier<Edition> pq=EditionQualify.PQ.lastEdition(condition);
		List<Edition> list=editionDaoImpl.subCollection(pq);
		
		return Message.success(list.stream().findFirst().orElse(null));
	}
	
	/**
	 * 新增版本
	 */
	@RequestMapping(value = "addList.do", method = RequestMethod.POST)
	@Override
	public Message<Long> addList(@RequestBody List<Edition> list) {
		return Message.success(editionDaoImpl.add(list));
	}

	/**
	 * 更新版本状态
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "updateList.do", method = RequestMethod.POST)
	@Override
	public Message<Long> updateList(@RequestBody List<Edition> list) {
		return Message.success(editionDaoImpl.update(list));
	}

	
	
	
	/**
	 * 版本
	 * @param p
	 * @return
	 */
	@RequestMapping(value = "queryone.do", method = RequestMethod.POST)
	public Message<EditionFacet> queryOne(@RequestBody Principle<Long> condition) {
		EditionDetailAppearance init=new EditionDetailAppearance(condition.getId());
		EditionDetailAppearance pre=service.view(init);
		return Message.success(pre.getEditionFacet());
	}
	
	/**
	 * 版本列表
	 * 
	 * @param a
	 * @return
	 */
	@RequestMapping(value = "queryinpage.do", method = RequestMethod.POST)
	public Message<Page<EditionExplorerFacet>> queryPage(@RequestBody PageCondition<EditionViewPageInit> condition) {
		EditionViewPageAppearance init=new EditionViewPageAppearance(condition);
		EditionViewPageAppearance pre=service.view(init);
		return Message.success(pre.getPage());
	}
	
	/**
	 * 版本对比
	 * TODO 改变了入参结构
	 * @param a
	 * @return
	 */
	@RequestMapping(value = "queryComparison.do", method = RequestMethod.POST)
	public Message<EditionComparisonFacet> queryComparison(@RequestBody EditionComparisonInit condition) {
		EditionComparisonAppearance init=new EditionComparisonAppearance(condition);
		EditionComparisonAppearance pre=service.view(init);
		return Message.success(pre.getEditionComparisonFacet());
	}
	
	/**
	 * 版本对比
	 * 
	 * @param a
	 * @return
	 */
	@RequestMapping(value = "queryoneComparison.do", method = RequestMethod.POST)
	public Message<EditionComparisonFacet> queryoneComparison(@RequestBody Principle<Long> condition) {
		EditionComparisonLastAppearance init=new EditionComparisonLastAppearance(condition.getId());
		EditionComparisonLastAppearance pre=service.view(init);
		return Message.success(pre.getEditionComparisonFacet());
	}



}
