package xyz.zhiwei.edition.web;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import xyz.zhiwei.cognitivedesign.dao.Dao;
import xyz.zhiwei.edition.api.EventApi;
import xyz.zhiwei.edition.api.support.Message;
import xyz.zhiwei.edition.morphism.principle.edition.model.EditEvent;

@RestController
@RequestMapping({"/event"})
public class EditEventController implements EventApi{


    @Autowired
    private Dao<EditEvent> editEventDaoImpl;
    

	/**
	 * 新增
	 * @author zhanghaiting
	 */
	@RequestMapping(value = "addList.do", method = RequestMethod.POST)
	@Override
	public Message<Long> addList(@RequestBody List<EditEvent> list) {
		return Message.success(editEventDaoImpl.add(list));
	}

}
