package xyz.zhiwei.edition.morphism.support.util;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;


/**
 * @author zhanghaiting
 * @date 2016年5月30日
 */
public class ObjectExtend {

	
	/**
	 * 是否奇数
	 * 判断奇偶性
	 * @param a
	 * @return
	 */
	public static boolean isOddNum(Integer a){
		int b=a%2;
		if(b==0){
			return false;
		}else{
			return true;
		}
	}
	
	
    /**
     * 字符串非空判断
     */
    public static boolean isEmpty(String s) {
        return !hasSubstance(s);
    }
	
	
    /**
     * 字符串非空判断
     */
    public static boolean hasSubstance(String s) {
        boolean sign = true;
        if (s == null ){
            sign = false;
        }else{
            s=s.trim();
        	if( "".equals(s) || "null".equals(s)) {
                sign = false;
        	}
        }
        return sign;
    }
    
    
    
    /**
     * 0不变，1新增，2删除，4修改  ====参阅ConnotationDifferenceModel
     * @param a
     * @param b
     * @return
     */
    public static Integer contrastStr(String a,String b){
    	Integer result=0;
    	
    	if(isEmpty(a)){
    		if(hasSubstance(b)){
    			return 1;
    		}
    	}
    	

    	if(hasSubstance(a)){
    		if(isEmpty(b)){
    			return 2;
    		}
    	}
    	
    	if(hasSubstance(a) && hasSubstance(b)){
    		if(!a.equals(b)){
    			return 4;
    		}
    	}
    	
    	return result;
    }
    
    
    /**
     * //0不变，1新增，2删除，3,重排，4修改,5重排并修改
     * @param updateNameType
     * @param isReorder
     * @return
     */
    public static Integer getUpdateType(Integer updateNameType,boolean isReorder){
    	if(isReorder){
        	if(0==updateNameType){
    			return 3;
        	}else if(4==updateNameType){
        		return 5;
        	}
    	}
    	return updateNameType;
    }
    
    
    
    
    //首字母变大写
    public static String upperCase(String str) {  
    	if(null==str){
    		return null;
    	}else if(ObjectExtend.isEmpty(str)){
    		return "";
    	}
        return str.substring(0, 1).toUpperCase() + str.substring(1);  
    }  
    
    

    /**
     * 深克隆
     */
    @SuppressWarnings("unchecked")
    public static <T> T deepClone(T src) {
        T o = null;
        try {
            if (src != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(src);
                oos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos
                        .toByteArray());
                ObjectInputStream ois = new ObjectInputStream(bais);
                o = (T) ois.readObject();
                ois.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return o;
    }

}
