package xyz.zhiwei.edition.morphism.principle.explorer.qualify;

import java.util.List;
import java.util.stream.Collectors;

import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.edition.morphism.principle.base.qualify.BaseQualify;
import xyz.zhiwei.edition.morphism.principle.base.qualify.PkListQualify;
import xyz.zhiwei.edition.morphism.principle.base.qualify.PkQualify;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.explorer.model.Explorer;

/**
 * 探索者限定器
 */
public class ExplorerQualify extends BaseQualify<Explorer> implements 
															PkQualify<Long,Explorer>,
															PkListQualify<Explorer>{

	public static final ExplorerQualify PQ=new ExplorerQualify();
	
	

	/**
	 * 子集限定符：版本列表里的探索者
	 * @param editionList
	 * @return
	 */
	public PrincipleQualifier<Explorer> explorerList(List<Edition> editionList){
		List<Explorer> idList=editionList.stream()
				.map(c -> new Explorer(c.getAuthorId()))
				.collect(Collectors.toList());

		return pkList(idList);
	}
	
	
	
}
