package xyz.zhiwei.edition.morphism.facet.edition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import xyz.zhiwei.edition.morphism.principle.article.model.Paragraph;
import xyz.zhiwei.edition.morphism.principle.base.model.OrderPrinciple;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.edition.model.base.Connotation;
import xyz.zhiwei.edition.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.edition.morphism.support.facet.LinkTwoListFacet;
import xyz.zhiwei.edition.morphism.support.util.ObjectExtend;
import xyz.zhiwei.edition.morphism.support.util.ObjectReflect;


/**
 * 版本对比模型
 * @author Aureole
 *
 */
public class EditionComparisonFacet implements Serializable {

	private static final long serialVersionUID = -1123593847385802490L;
	private Integer updateTypeName=0;
	private Integer updateTypeCentralIdea=0;
	private Integer updateTypeReference=0;
	
	
	private ComparisonFacet<EditionWithAuthorFacet> editionMain;
	
	
	private List<ComparisonFacet<Connotation>> connotationList;
	

	private List<ComparisonFacet<Paragraph>> paragraphList;


	public EditionComparisonFacet() {}

	
	/**
	 * 构造方法
	 * @param condition
	 * @param editionList
	 * @param explorerList
	 */
	public EditionComparisonFacet(EditionComparisonInit condition,List<Edition> editionList,List<Explorer> explorerList) {

		//版本列表填充作者信息
		LinkTwoListFacet<EditionWithAuthorFacet> editionWithAuthorModelList=new LinkTwoListFacet<>(
				editionList,explorerList,Edition::getAuthorId, Explorer::getId,
				EditionWithAuthorFacet::new);
		
		//=======================信息索引=======================
		Long aId=condition.getEditionIdA();
		EditionWithAuthorFacet editionModelA=null;
		EditionWithAuthorFacet editionModelB=null;
		if(aId.equals(editionWithAuthorModelList.get(0).getId())) {
			editionModelA=editionWithAuthorModelList.get(0);
			editionModelB=editionWithAuthorModelList.get(1);
		}else {
			editionModelA=editionWithAuthorModelList.get(1);
			editionModelB=editionWithAuthorModelList.get(0);
		}
		
		setEditionComparisonFacet(editionModelA, editionModelB);
	}
	
	
	/**
	 * 构造方法
	 * @param editionA
	 * @param editionB
	 */
	public EditionComparisonFacet(Edition editionA,Edition editionB,
			List<Explorer> explorerList){
		List<Edition> editionList=List.of(editionA,editionB);
		//版本列表填充作者信息
		LinkTwoListFacet<EditionWithAuthorFacet> editionWithAuthorModelList=new LinkTwoListFacet<>(
				editionList,explorerList,Edition::getAuthorId, Explorer::getId,
				EditionWithAuthorFacet::new);
		
		//=======================信息索引=======================
		Long aId=editionA.getId();
		EditionWithAuthorFacet editionModelA=null;
		EditionWithAuthorFacet editionModelB=null;
		if(aId.equals(editionWithAuthorModelList.get(0).getId())) {
			editionModelA=editionWithAuthorModelList.get(0);
			editionModelB=editionWithAuthorModelList.get(1);
		}else {
			editionModelA=editionWithAuthorModelList.get(1);
			editionModelB=editionWithAuthorModelList.get(0);
		}
		
		setEditionComparisonFacet(editionModelA,editionModelB);
	}
	
	
	/**
	 * 对比两个版本
	 * @param EditionModelA
	 * @param EditionModelB
	 * @return
	 */
	public void setEditionComparisonFacet(EditionWithAuthorFacet EditionModelA,EditionWithAuthorFacet EditionModelB){
		ComparisonFacet<EditionWithAuthorFacet> editionMain=new ComparisonFacet<>();

		editionMain.setModelA(EditionModelA);
		editionMain.setModelB(EditionModelB);

		
		
		List<Connotation> connotationListA=EditionModelA.getConnotationList();
		List<Connotation> connotationListB=EditionModelB.getConnotationList();
		List<Paragraph> paragraphListA=EditionModelA.getParagraphList();
		List<Paragraph> paragraphListB=EditionModelB.getParagraphList();
		

		this.editionMain=editionMain;
		//=======================版本信息对比=======================
		//对比概念名称
		this.updateTypeName=contrastStr(EditionModelA.getConcept(), EditionModelB.getConcept());
		//对比中心思想
		this.updateTypeCentralIdea=contrastStr(EditionModelA.getCentralIdea(), EditionModelB.getCentralIdea());
		//对比文献
		this.updateTypeReference=contrastStr(EditionModelA.getReference(), EditionModelB.getReference());
		
		
		//=======================对比内涵空间=======================
		List<ComparisonFacet<Connotation>> connotationComparisonList=contrastList(connotationListA, connotationListB,1);
		this.connotationList=connotationComparisonList;
		
		//=======================对比段落及摘要=======================
		List<ComparisonFacet<Paragraph>> paragraphComparisonList=contrastList(paragraphListA, paragraphListB,2);
		this.paragraphList=paragraphComparisonList;
		
	}
	

	
	/**
	 * 对比列表
	 * objectContrastType:1内涵；2段落
	 * @return
	 */
	private <T extends OrderPrinciple<Long>> List<ComparisonFacet<T>> contrastList(
			List<T> listA,
			List<T> listB,
			Integer objectContrastType
			){
		if(null==listA){listA=new ArrayList<>();}
		if(null==listB){listB=new ArrayList<>();}
		
		//列表添加辅助分析属性
		List<OrderComparisonFacet<T>> listCA=listA.stream().map(OrderComparisonFacet::new).collect(Collectors.toList());
		List<OrderComparisonFacet<T>> listCB=listB.stream().map(OrderComparisonFacet::new).collect(Collectors.toList());
		
		
		List<ComparisonFacet<T>> comparisonList=new ArrayList<ComparisonFacet<T>>();

		List<OrderComparisonFacet<T>> shareListA=new ArrayList<>();
		List<OrderComparisonFacet<T>> shareListB=new ArrayList<>();
		
		//找出共同的元素列表
		findeShareList(listCA, listCB, shareListA, shareListB);
		Map<Long,OrderComparisonFacet<T>> shareMapA=shareListA.stream()
		        .collect(Collectors.toMap(item -> item.getModel().getId(),Function.identity(),                     
			            (existing, replacement) -> existing
			        ));;
		Map<Long,OrderComparisonFacet<T>> shareMapB=shareListB.stream()
		        .collect(Collectors.toMap(item -> item.getModel().getId(),Function.identity(),                     
			            (existing, replacement) -> existing
			        ));;
		
		
		
		//找出最大的正序列表
		List<OrderComparisonFacet<T>> shareOrderListB=findOrderList(shareListB);
		Map<Long,OrderComparisonFacet<T>> shareOrderMapB=shareOrderListB.stream()
		        .collect(Collectors.toMap(item -> item.getModel().getId(),Function.identity(),                     
			            (existing, replacement) -> existing
			        ));;
				
		
		
		//生成左侧主干
		for (int i = 0; i < listA.size(); i++) {
			T oneA=listA.get(i);
			Long idA= oneA.getId();

			ComparisonFacet<T> oneComparison=new ComparisonFacet<T>();
			oneComparison.setModelA(oneA);
			

			boolean isIdAExistInOrderB=shareOrderMapB.containsKey(idA);
			if(isIdAExistInOrderB){
				OrderComparisonFacet<T> oneB=shareOrderMapB.get(idA);
				oneComparison.setModelB(oneB.getModel());
				
				Integer updateNameType=0;
				updateNameType=getUpdateType(oneA, oneB.getModel(), objectContrastType, updateNameType);
				oneComparison.setUpdateType(updateNameType);
				
			}else{
				boolean isInShareListA=shareMapA.containsKey(idA);
				if(isInShareListA){
					OrderComparisonFacet<T> oneB=shareMapB.get(idA);

					Integer updateNameType=3;
					updateNameType=getUpdateType(oneA, oneB.getModel(), objectContrastType, updateNameType);

					oneComparison.setUpdateType(updateNameType);
				}else{
					oneComparison.setUpdateType(2);
				}
			}
			comparisonList.add(oneComparison);
		}
		
		
		
		//剩余元素归位
		for (int i = 0; i < listB.size(); i++) {
			T oneB=listB.get(i);
			Long idB= oneB.getId();
			if(shareOrderMapB.containsKey(idB)){continue;}
			
			
			ComparisonFacet<T> oneComparison=new ComparisonFacet<T>();
			oneComparison.setModelB(oneB);
			
			if(shareMapB.containsKey(idB)){
				OrderComparisonFacet<T> oneA=shareMapA.get(idB);
				Integer updateNameType=3;
				updateNameType=getUpdateType(oneA.getModel(), oneB, objectContrastType, updateNameType);
				oneComparison.setUpdateType(updateNameType);
			}else{
				oneComparison.setUpdateType(1);
			}
			Integer indexOfB=getIndexOfBInComparisonList(oneB.getSequence(), comparisonList);
			comparisonList.add(indexOfB, oneComparison);
			
		}
		
		
		return comparisonList;
	}

	/**
	 * 根据B的id,在对比列表中找到B的位置
	 * @param idB
	 * @param comparisonList
	 * @return
	 */
	private <T extends OrderPrinciple<Long>> int getIndexOfBInComparisonList(Integer sequenceOfB,List<ComparisonFacet<T>> comparisonList){
		
		Integer indexOfB=0;
		
		for (int i = 0; i < comparisonList.size(); i++) {
			ComparisonFacet<T> oneComparison=comparisonList.get(i);
			T modelB=oneComparison.getModelB();
			if(null!=modelB){
				Integer oneSequenceOfB = modelB.getSequence();
				if(oneSequenceOfB>sequenceOfB){
					return i;
				}else{
					indexOfB=i+1;
				}
			}
		}
		
		return indexOfB;
		
	}
	

	/**
	 * 找出共同的元素列表
	 * @param orgListA
	 * @param orgListB
	 * @param shareListA
	 * @param shareListB
	 */
	private <T extends OrderPrinciple<Long>> void findeShareList(List<OrderComparisonFacet<T>> orgListA,List<OrderComparisonFacet<T>> orgListB,List<OrderComparisonFacet<T>> shareListA,List<OrderComparisonFacet<T>> shareListB){

		Map<Long,OrderComparisonFacet<T>> orgMapA=orgListA.stream()
		        .collect(Collectors.toMap(item -> item.getModel().getId(),Function.identity(),                     
		            (existing, replacement) -> existing
		        ));;
		Map<Long,OrderComparisonFacet<T>> orgMapB=orgListB.stream()
		        .collect(Collectors.toMap(item -> item.getModel().getId(),Function.identity(),                     
			            (existing, replacement) -> existing
			        ));;
		
		
		//分析是否共有
		for (int i = 0; i < orgListA.size(); i++) {
			OrderComparisonFacet<T> oneOrgA=orgListA.get(i);
			Long oneOrgAid=oneOrgA.getModel().getId();
			if(orgMapB.containsKey(oneOrgAid)){
				shareListA.add(oneOrgA);
			}
		}
		
		for (int i = 0; i < orgListB.size(); i++) {
			OrderComparisonFacet<T> oneOrgB=orgListB.get(i);
			Long oneOrgBid=oneOrgB.getModel().getId();
			if(orgMapA.containsKey(oneOrgBid)){
				shareListB.add(oneOrgB);
			}
		}
		
		//添加序号
		for (int i = 0; i < shareListA.size(); i++) {
			Long oneShareAid=shareListA.get(i).getModel().getId();
			orgMapB.get(oneShareAid).setSequenceA(i);
		}
		
		for (int i = 0; i < shareListB.size(); i++) {
			shareListB.get(i).setSequenceB(i);
		}
		
	}


	/**
	 * 元素对比差异
	 * @param oneA
	 * @param oneB
	 * @param objectContrastType
	 * @param baseType
	 * @return
	 */
	private <T extends OrderPrinciple<Long>> int getUpdateType(T oneA,T oneB,Integer objectContrastType,int baseType){

		
		if(baseType==0){
			
			//比较差异
			if(1==objectContrastType){
				baseType=ObjectExtend.contrastStr(oneA.getName(), oneB.getName());
			}else if(2==objectContrastType){
				
				Integer updateTextType=ObjectExtend.contrastStr((String)ObjectReflect.getModelMethodReturn(oneA, "getText"), (String)ObjectReflect.getModelMethodReturn(oneB, "getText"));
				Integer updateDigestType=ObjectExtend.contrastStr((String)ObjectReflect.getModelMethodReturn(oneA, "getDigest"), (String)ObjectReflect.getModelMethodReturn(oneB, "getDigest"));

				if(4==updateTextType || 4==updateDigestType){
					baseType=4;
				}
				if(2==updateTextType && 2==updateDigestType){
					baseType=2;
				}
				if(0==baseType && (2==updateTextType || 2==updateDigestType)){
					baseType=4;
				}
			}
			
			
		}else if(baseType==3){

			Integer updateNameType=0;

			//比较差异
			if(1==objectContrastType){
				updateNameType=ObjectExtend.contrastStr(oneA.getName(), oneB.getName());
				if(0!=updateNameType){
					updateNameType=5;
				}else{
					updateNameType=3;
				}
			}else if(2==objectContrastType){
				Integer updateTextType=ObjectExtend.contrastStr((String)ObjectReflect.getModelMethodReturn(oneA, "getText"), (String)ObjectReflect.getModelMethodReturn(oneB, "getText"));
				Integer updateDigestType=ObjectExtend.contrastStr((String)ObjectReflect.getModelMethodReturn(oneA, "getDigest"), (String)ObjectReflect.getModelMethodReturn(oneB, "getDigest"));

				if(4==updateTextType || 4==updateDigestType){
					updateNameType=4;
				}
				if(2==updateTextType && 2==updateDigestType){
					updateNameType=2;
				}
				if(0==updateNameType && (2==updateTextType || 2==updateDigestType)){
					updateNameType=4;
				}
				
				
				if(0!=updateNameType){
					updateNameType=5;
				}else{
					updateNameType=3;
				}
				
			}
			
			baseType=updateNameType;
			
		}
		
		
		return baseType;
	}
    
    

	/**
	 * 找出列表中排正序的元素
	 * @param list
	 * @return
	 */
	private <T extends OrderPrinciple<Long>> List<OrderComparisonFacet<T>> findOrderList(List<OrderComparisonFacet<T>> list){
		
		//当前要分析的列表
		List<List<OrderComparisonFacet<T>>> nowList=new ArrayList<>();
		//下次要分析的列表
		List<List<OrderComparisonFacet<T>>> nextlist=new ArrayList<>();
		
		//初始化
		nowList.add(list);
		//递归次数
		Integer findTimes=0;
		
		//===========递归操作准入条件===========
		while(nowList.size()>0 && findTimes<100){
			findTimes++;
			for (int i = 0; i < nowList.size(); i++) {
				List<OrderComparisonFacet<T>> oneList=nowList.get(i);
				
				boolean isOrder=isOrderList(oneList);
				if(isOrder){
					return oneList;
				}else{
					boolean isOddTime=isOddNum(findTimes);
					List<OrderComparisonFacet<T>> oneListToRemoveBig=ObjectExtend.deepClone(oneList);
					List<OrderComparisonFacet<T>> oneListToRemoveSmall=ObjectExtend.deepClone(oneList);
					
					if(isOddTime){
						//正向移除一个逆序数
						removeOneByASC(oneListToRemoveBig, true);
						removeOneByASC(oneListToRemoveSmall, false);
						
						nextlist.add(oneListToRemoveBig);
						nextlist.add(oneListToRemoveSmall);
					}else{
						//反向移除一个逆序数
						removeOneByDesc(oneListToRemoveBig, true);
						removeOneByDesc(oneListToRemoveSmall, false);
						
						nextlist.add(oneListToRemoveSmall);
						nextlist.add(oneListToRemoveBig);
					}
				}
				
			}
			
			//重置递归条件
			nowList=nextlist;
			nextlist=new ArrayList<>();
		}
		
		return new ArrayList<>();
	}

	
	/**
	 * 正序查找，移除一个逆序中的大/小值
	 * @param oneListToRemoveBig
	 */
	private <T extends OrderPrinciple<Long>> void removeOneByASC(List<OrderComparisonFacet<T>> listToRemove,boolean isRemoveBig){

		Integer previousSequence=-1;
		for (int i = 0; i < listToRemove.size(); i++) {
			OrderComparisonFacet<T> one=listToRemove.get(i);
			Integer oneSequenceA=one.getSequenceA();
			if(oneSequenceA>previousSequence){
				previousSequence=oneSequenceA;
			}else{
				int removeIndex=i;
				if(isRemoveBig){
					removeIndex=i-1;
				}
				listToRemove.remove(removeIndex);
				break;
			}
		}
		
		
	}
	
	/**
	 * 逆序查找，移除一个逆序中的大/小值
	 * @param oneListToRemoveBig
	 */
	private <T extends OrderPrinciple<Long>> void removeOneByDesc(List<OrderComparisonFacet<T>> listToRemove,boolean isRemoveBig){
		
		Integer previousSequence=10000;
		for (int i = listToRemove.size()-1; i >=0; i--) {
			OrderComparisonFacet<T> one=listToRemove.get(i);
			Integer oneSequenceA=one.getSequenceA();
			if(oneSequenceA<previousSequence){
				previousSequence=oneSequenceA;
			}else{
				int removeIndex=i;
				if(!isRemoveBig){
					removeIndex=i+1;
				}
				listToRemove.remove(removeIndex);
				break;
			}
		}
		
	}

	/**
	 * 是否奇数
	 * 判断奇偶性
	 * @param a
	 * @return
	 */
	private boolean isOddNum(Integer a){
		int b=a%2;
		if(b==0){
			return false;
		}else{
			return true;
		}
	}

	/**
	 * 检查列表是否已是正序
	 * @param list
	 * @return
	 */
	private <T extends OrderPrinciple<Long>> boolean isOrderList(List<OrderComparisonFacet<T>> list){
		Long previousSequence=-1L;
		for (int i = 0; i < list.size(); i++) {
			OrderComparisonFacet<T> one=list.get(i);
			Integer oneSequenceA=one.getSequenceA();
			if(oneSequenceA>previousSequence.intValue()){
				previousSequence=Long.valueOf(oneSequenceA);
			}else{
				return false;
			}
		}
		return true;
	}
	
	
	
	
    /**
     * 0不变，1新增，2删除，4修改  ====参阅ConnotationDifferenceModel
     * @param a
     * @param b
     * @return
     */
    private Integer contrastStr(String a,String b){
    	Integer result=0;
    	
    	if(ObjectExtend.isEmpty(a)){
    		if(ObjectExtend.hasSubstance(b)){
    			return 1;
    		}
    	}
    	

    	if(ObjectExtend.hasSubstance(a)){
    		if(ObjectExtend.isEmpty(b)){
    			return 2;
    		}
    	}
    	
    	if(ObjectExtend.hasSubstance(a) && ObjectExtend.hasSubstance(b)){
    		if(!a.equals(b)){
    			return 4;
    		}
    	}
    	
    	return result;
    }




	public Integer getUpdateTypeName() {
		return updateTypeName;
	}



	public Integer getUpdateTypeCentralIdea() {
		return updateTypeCentralIdea;
	}



	public Integer getUpdateTypeReference() {
		return updateTypeReference;
	}



	public ComparisonFacet<EditionWithAuthorFacet> getEditionMain() {
		return editionMain;
	}



	public List<ComparisonFacet<Connotation>> getConnotationList() {
		return connotationList;
	}



	public List<ComparisonFacet<Paragraph>> getParagraphList() {
		return paragraphList;
	}
	
    
	
}
