package xyz.zhiwei.edition.morphism.appearance.edition.page;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.edition.morphism.principle.explorer.qualify.ExplorerQualify;
import xyz.zhiwei.edition.morphism.support.facet.PageCondition;

/**
 * 版本分页
 */
public class EditionViewPageAppearance implements Appearance{

	//init
    private PageCondition<EditionViewPageInit> init;

    //=============原象=============
    private Source source;
    //版本列表
    private List<Edition> editionList;
    //关联的探索者列表
    private List<Explorer> explorerList;
	

    //=============构造=============
	//版本分页
    private EditionExplorerPage page;
    

    //初始化
	public EditionViewPageAppearance(PageCondition<EditionViewPageInit>  init) {
		this.init=init;
	}

	
    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {

		//核心集定义：概念的版本列表
    	PrincipleQualifier<Edition> coreQualifier=Qualify.page(this.init);
		
		return new PrincipleQualifiers(coreQualifier);
	};

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.editionList=this.source.getEditionList();

		//关联集：作者信息
    	PrincipleQualifier<Explorer> explorerQualifier=ExplorerQualify.PQ.explorerList(this.editionList);
		
		return new PrincipleQualifiers(explorerQualifier);
	};

	

	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.explorerList=this.source.getExplorerList();
		
		//版本分页
		this.page=new EditionExplorerPage(this.editionList,this.explorerList);

        return this;
	}


	public EditionExplorerPage getPage() {
		return page;
	}


    
}
