package xyz.zhiwei.edition.morphism.appearance.edition.page;

import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSourcePage;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.edition.morphism.support.facet.LinkTwoListFacet;
import xyz.zhiwei.edition.morphism.support.facet.Page;

/**
 * 版本列表分页
 */
public class EditionExplorerPage extends Page<EditionExplorerFacet>{
	private static final long serialVersionUID = 1L;
	
	
	/**
	 * 
	 * @param editionList
	 * @param explorerList
	 */
	public EditionExplorerPage(List<Edition> editionList,List<Explorer> explorerList) {
		
		LinkTwoListFacet<EditionExplorerFacet> linkTwoListFacet=new LinkTwoListFacet<>(
				editionList,explorerList,Edition::getAuthorId, Explorer::getId,
				EditionExplorerFacet::new);

		Long total=((PrincipleSourcePage<Edition>)editionList).getTotal();
		
		this.addAll(linkTwoListFacet);
		this.setTotal(total);
	}
	

}
