package xyz.zhiwei.edition.morphism.appearance.edition.detail;

import java.util.List;

import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.edition.morphism.principle.article.model.Contribution;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.explorer.model.Explorer;

/**
 * 
 */
class Source{
	
	
	/**
	 * List<PrincipleSource>
	 * 0: [版本本身，    ] 
	 * 0: [List<Edition>] 
	 * 
	 * 1: [版本作者,       版本的贡献值]
	 * 1: [List<Explorer>，List<Contribution>]
	 * 
	 * 
	 */
	private List<PrincipleSource> principleSourceList;
	
	Source(List<PrincipleSource> principleSourceList) {
		this.principleSourceList=principleSourceList;
	}

	
	/**
	 * 版本本身
	 * @param this.principleSourceList
	 * @return
	 */
	Edition getEdition() {
		@SuppressWarnings("unchecked")
		List<Edition> list=(List<Edition>) this.principleSourceList.getFirst().getFirst();
		return list.isEmpty() ? null : list.get(0);
	}
	
	
	/**
	 * 版本作者
	 * @param this.principleSourceList
	 * @return
	 */
	Explorer getAuthor() {
		@SuppressWarnings("unchecked")
		List<Explorer> list=(List<Explorer>) this.principleSourceList.get(1).getFirst();
		return list.isEmpty() ? null : list.get(0);
	}
	
	
	
	/**
	 * 版本贡献值
	 * @param this.principleSourceList
	 * @return
	 */
	Contribution getContribution() {
		@SuppressWarnings("unchecked")
		List<Contribution> list=(List<Contribution>) this.principleSourceList.get(1).get(1);
		return list.isEmpty() ? null : list.get(0);
	}
	
	

}
