package xyz.zhiwei.edition.morphism.appearance.edition.detail;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.edition.morphism.principle.article.model.Contribution;
import xyz.zhiwei.edition.morphism.principle.article.qualify.ContributionQualify;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.edition.qualify.EditionQualify;
import xyz.zhiwei.edition.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.edition.morphism.principle.explorer.qualify.ExplorerQualify;


/**
 * 版本表象
 */
public class EditionDetailAppearance implements Appearance{

	//init:id
    private Long initId;

    //=============原象=============
    private Source source;
    //版本本身
    private Edition edition;
    //版本的作者
    private Explorer author;
    //版本的贡献值
    private Contribution contribution;
    
    //=============构造=============
    //版本本身
    private EditionFacet editionFacet;
    
    
    //初始化
	public EditionDetailAppearance(Long initId) {
		this.initId=initId;
	}
	

    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询：
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {

		//核心集定义：版本本身
    	PrincipleQualifier<Edition> coreQualifier=EditionQualify.PQ.pk(this.initId);
		
		return new PrincipleQualifiers(coreQualifier);
	};

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.edition=this.source.getEdition();

		//关联集：作者信息
    	PrincipleQualifier<Explorer> explorerQualifier=ExplorerQualify.PQ.pk(edition.getAuthorId());
		
		//关联集：领域贡献信息
    	PrincipleQualifier<Contribution> contributionQualifier=ContributionQualify.PQ.fk(new Contribution(edition.getConceptId(),edition.getAuthorId()));
		
    	
		return new PrincipleQualifiers(explorerQualifier,contributionQualifier);
	};
	
	
	
	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.author=this.source.getAuthor();
		this.contribution=this.source.getContribution();
		
		//版本本身
		this.editionFacet=new EditionFacet(this.edition,this.author,this.contribution);

        return this;
	}


	public EditionFacet getEditionFacet() {
		return editionFacet;
	}


}