package xyz.zhiwei.edition.morphism.appearance.edition.comparison;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import xyz.zhiwei.cognitivedesign.morphism.Appearance;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifier;
import xyz.zhiwei.cognitivedesign.morphism.support.qualifier.PrincipleQualifiers;
import xyz.zhiwei.cognitivedesign.morphism.support.source.PrincipleSource;
import xyz.zhiwei.edition.morphism.facet.edition.EditionComparisonFacet;
import xyz.zhiwei.edition.morphism.facet.edition.EditionComparisonInit;
import xyz.zhiwei.edition.morphism.principle.edition.model.Edition;
import xyz.zhiwei.edition.morphism.principle.edition.qualify.EditionQualify;
import xyz.zhiwei.edition.morphism.principle.explorer.model.Explorer;
import xyz.zhiwei.edition.morphism.principle.explorer.qualify.ExplorerQualify;


/**
 * 版本对比
 */
public class EditionComparisonAppearance implements Appearance{

	//init
    private EditionComparisonInit init;

    //=============原象=============
    private Source source;
    //版本本身
    private List<Edition> editionList;
    //版本的作者
    private List<Explorer> authorList;
    
    //=============构造=============
    //版本对比
    private EditionComparisonFacet editionComparisonFacet;
    
    
    //初始化
	public EditionComparisonAppearance(EditionComparisonInit init) {
		this.init=init;
	}
	

    @Override
	public List<Function<List<PrincipleSource>,PrincipleQualifiers>> qualifierFunction(){
		return Arrays.asList(this::qualifierGroup1st,this::qualifierGroup2nd);
	}
    

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * 第一次查询：
	 * @param principleSourceList
	 * @return
	 */
    @Override
    public PrincipleQualifiers qualifierGroup1st(List<PrincipleSource> principleSourceList) {

		//核心集定义：版本本身
    	PrincipleQualifier<Edition> coreQualifier=EditionQualify.PQ.pkList(this.init.getList());
		
		return new PrincipleQualifiers(coreQualifier);
	};

	/**
	 * 关系1：表象所关联的本原集(定义)
	 * @param principleSourceList
	 * @return
	 */
    private PrincipleQualifiers qualifierGroup2nd(List<PrincipleSource> principleSourceList) {
    	this.source=new Source(principleSourceList);
    	this.editionList=this.source.getEdition();

		//关联集：作者信息
    	PrincipleQualifier<Explorer> explorerQualifier=ExplorerQualify.PQ.explorerList(this.editionList);
		
		return new PrincipleQualifiers(explorerQualifier);
	};
	
	
	
	/**
	 * 关系2之一：表象由本原集构造而成
	 * 入参列表对应上面的查询函数列表
	 * @param relatedCollectionList
	 * @return
	 */
	@Override
	public Appearance construct(List<PrincipleSource> principleSourceList){
		//本原
		this.editionList=this.source.getEdition();
		this.authorList=this.source.getAuthor();
		
		//版本本身
		this.editionComparisonFacet=new EditionComparisonFacet(this.init,this.editionList,this.authorList);

        return this;
	}


	public EditionComparisonFacet getEditionComparisonFacet() {
		return editionComparisonFacet;
	}



}